/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.certapply;

import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Container;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.web.manager.certapply.bean.CheckInfoReq;
import com.xdja.pki.ra.web.manager.certapply.bean.ErrorMsgReq;
import com.xdja.pki.ra.web.manager.certapply.bean.IssueByUkeyReq;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class CertApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    CertLifeCycleManager certLifeCycleManager;
    @Autowired
    AuditLogService auditLogService;
    @Autowired
    RaSdkCache raSdkCache;

    @RequestMapping(value={"/v1/user/cert/apply"}, method={RequestMethod.GET})
    public Object listUserCertApply(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="userType", required=false) Integer userType, @RequestParam(value="applyStatus", required=false) Integer applyStatus, @RequestParam(value="userCA", required=false) String userCA, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.listUserCertApply>>>>>>userName:{}, userType:{}, applyStatus:{}, userCA:{}, pageNo:{}, pageSize:{},startTime:{},endTime:{}", new Object[]{userName, userType, applyStatus, userCA, pageNo, pageSize, startTime, endTime});
        if (userType == null || userType != 1 && userType != 2 && userType != 3) {
            userType = 0;
        }
        if (applyStatus == null || applyStatus < 1 || applyStatus > 11) {
            applyStatus = 0;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.certApplyService.listUserApply(userCA, userName, userType.intValue(), applyStatus.intValue(), pageNo, pageSize, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u8bc1\u4e66\u7533\u8bf7\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.listUserCertApply>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/check/{applyNo}"}, method={RequestMethod.PUT})
    public Object checkUserCertApply(@PathVariable String applyNo, @Valid @RequestBody CheckInfoReq checkInfoReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.checkUserCertApply>>>>>>applyNo:" + applyNo + " checkInfoReq:" + JsonUtils.object2Json((Object)checkInfoReq));
        if (StringUtils.isBlank((CharSequence)applyNo) || checkInfoReq == null || checkInfoReq.getPass() == null) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u5ba1\u6838\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.certApplyService.checkUserCertApply(applyNo, null, checkInfoReq.getApplyType(), checkInfoReq.getPass().booleanValue(), checkInfoReq.getCheckInfo(), false);
        }
        catch (Exception e) {
            this.logger.error("\u5ba1\u6838\u8bc1\u4e66\u7533\u8bf7\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u5ba1\u6838\u5458\u5ba1\u6838\u7533\u8bf7\u3010\u5931\u8d25\u3011\uff0c\u5ba1\u6838\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.AUDIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u5ba1\u6838\u5458\u5ba1\u6838\u7533\u8bf7\u3010\u6210\u529f\u3011\uff0c\u5ba1\u6838\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.AUDIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertApplyController.checkUserCertApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/apply/baseDn"}, method={RequestMethod.GET})
    public Object getRaBaseDn(HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.getRaBaseDn>>>>>>start");
        try {
            result = this.certApplyService.getRaBaseDn();
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.getRaBaseDn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/apply/tempBaseDn/{tempNo}"}, method={RequestMethod.GET})
    public Object getBaseDn(@PathVariable String tempNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.getBaseDn>>>>>>tempNo:" + tempNo);
        if (StringUtils.isBlank((CharSequence)tempNo)) {
            ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.certApplyService.getBaseDn(tempNo);
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.getBaseDn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/apply/verifyDN"}, method={RequestMethod.GET})
    public Object verifyUserCertApplyDn(@RequestParam(value="certDn") String certDn, @RequestParam(value="userId") long userId, @RequestParam(value="applyNo", required=false) String applyNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.verifyUserCertApplyDn>>>>>>certDn:" + certDn + " userId:" + userId + " applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)certDn) || userId == 0L) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.certApplyService.verifyUserCertApplyDn(certDn, userId, applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u8bc1\u4e66\u7533\u8bf7DN\u6709\u6548\u6027\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.verifyUserCertApplyDn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/apply/verify"}, method={RequestMethod.GET})
    public Object verifyUserCertApplyBySignSn(@RequestParam(value="signSn") String signSn, @RequestParam(value="applyType") int applyType, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.verifyUserCertApplyBySignSn>>>>>>signSn:" + signSn);
        if (StringUtils.isBlank((CharSequence)signSn)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (applyType != 2 && applyType != 3 && applyType != 4 && applyType != 5 && applyType != 6) {
            return ErrorEnum.CERT_APPLY_TYPE_IS_ERROR.resp(resp);
        }
        try {
            result = this.certApplyService.verifyUserCertApply(signSn, applyType);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u662f\u5426\u5b58\u5728\u76f8\u540csn\u7684\u8bc1\u4e66\u7533\u8bf7\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.verifyUserCertApplyBySignSn>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/apply/record/{applyNo}"}, method={RequestMethod.GET})
    public Object listApplyRecord(@PathVariable String applyNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.listApplyRecord>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.certApplyService.listApplyRecord(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7533\u8bf7\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.listApplyRecord>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/ukey/{applyType}/{applyNo}"}, method={RequestMethod.POST})
    public Object genUserCertByUkey(@PathVariable int applyType, @PathVariable String applyNo, @Valid @RequestBody IssueByUkeyReq issueByUkeyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.genUserCertByUkey>>>>>>applyNo:" + applyNo + " issueByUkeyReq:" + JsonUtils.object2Json((Object)issueByUkeyReq));
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u901a\u8fc7\u5b89\u5168\u5361\u7b7e\u53d1\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (applyType != 1 && applyType != 2 && applyType != 4) {
            return ErrorEnum.CERT_APPLY_TYPE_IS_ERROR.resp(resp);
        }
        String userP10Str = issueByUkeyReq.getSignP10Str();
        try {
            result = this.certApplyService.issueUserCert(null, null, Integer.valueOf(1), applyType, applyNo, null, issueByUkeyReq.getCardNo(), userP10Str.getBytes(), 1, false, false, null, null);
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7\u5b89\u5168\u5361\u7b7e\u53d1\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        String applyTypeStr = null;
        switch (applyType) {
            case 1: {
                applyTypeStr = "\u7b7e\u53d1\u7533\u8bf7";
                break;
            }
            case 2: {
                applyTypeStr = "\u66f4\u65b0\u7533\u8bf7";
                break;
            }
            case 4: {
                applyTypeStr = "\u6062\u590d\u7533\u8bf7";
                break;
            }
            default: {
                applyTypeStr = " ";
            }
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4ee5\u5b89\u5168\u5361\u7b7e\u53d1\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4ee5\u5b89\u5168\u5361\u7b7e\u53d1\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr);
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertApplyController.genUserCertByUkey>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/ukey/{applyNo}"}, method={RequestMethod.GET})
    public Object genUserCertByRespUkey(@PathVariable String applyNo, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.genUserCertByRespUkey>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.certApplyService.issueUserCertResp(applyNo, null, false);
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7\u5b89\u5168\u5361\u7b7e\u53d1\u8bc1\u4e66-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b7e\u53d1\u8bc1\u4e66\u54cd\u5e94\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b7e\u53d1\u8bc1\u4e66\u54cd\u5e94\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertApplyController.genUserCertByRespUkey>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/p10"}, method={RequestMethod.POST})
    public Object genUserCertByP10(@RequestParam(value="applyType") int applyType, @RequestParam(value="certFormatType") int certFormatType, @RequestParam(value="applyNo") String applyNo, @RequestParam(value="keyIndex", required=false) Integer keyIndex, @RequestParam(value="priKeyPwd", required=false) String priKeyPwd, @RequestPart(value="cmf", required=false) MultipartFile cmf, @RequestParam(value="certDn", required=false) String certDn, AuditSignBean bean, HttpServletResponse resp) throws Exception {
        Result result;
        this.logger.info("CertApplyController.genUserCertByP10>>>>>>applyType:{} applyNo:{} certDn:{}", new Object[]{applyNo, applyType, certDn});
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            this.logger.warn("[CertApplyController#genUserCertByP10] req param [applyNo] is null.");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (applyType != 1 && applyType != 2 && applyType != 4 || certFormatType != 4 && certFormatType != 5) {
            this.logger.warn("[CertApplyController#genUserCertByP10] applyType\u662f3-\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7 \u6216\u8005 \u8bc1\u4e66\u7b7e\u53d1\u7c7b\u578b\u4e0d\u5c5e\u4e8e 4-P7B\uff0c5-BKS");
            return ErrorEnum.CERT_APPLY_TYPE_IS_ERROR.resp(resp);
        }
        byte[] p10FileBytes = null;
        if (cmf != null) {
            try {
                p10FileBytes = cmf.getBytes();
            }
            catch (IOException e) {
                throw new IOException();
            }
        }
        if (applyType == 1 && p10FileBytes.length == 0) {
            this.logger.info("\u7533\u8bf7\u4e66\u7533\u8bf7P10\u6587\u4ef6\u4e3a\u7a7a");
            return ErrorEnum.ISSUE_APPLY_P10_FILE_IS_EMPTY.resp(resp);
        }
        if (certFormatType == 5 && applyType == 1) {
            if (keyIndex == null) {
                return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
            }
            if (1 == CommonVariable.getIsHsm() && StringUtils.isBlank((CharSequence)priKeyPwd)) {
                return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
            }
        }
        HashMap<String, String> extParam = new HashMap<String, String>(4);
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            extParam.put("certDn", certDn);
        }
        try {
            result = this.certApplyService.issueUserCert(keyIndex, priKeyPwd, Integer.valueOf(certFormatType), applyType, applyNo, null, null, p10FileBytes, 2, false, false, extParam, null);
        }
        catch (Exception e) {
            this.logger.error("\u4ee5P10\u7533\u8bf7\u4e66\u65b9\u5f0f\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        String applyTypeStr = null;
        switch (applyType) {
            case 1: {
                applyTypeStr = "\u7b7e\u53d1\u7533\u8bf7";
                break;
            }
            case 2: {
                applyTypeStr = "\u66f4\u65b0\u7533\u8bf7";
                break;
            }
            case 4: {
                applyTypeStr = "\u6062\u590d\u7533\u8bf7";
                break;
            }
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4ee5P10\u65b9\u5f0f\u7b7e\u53d1\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4ee5P10\u65b9\u5f0f\u7b7e\u53d1\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        OutputStream out = null;
        try {
            List list = (List)result.getInfo();
            byte[] data = ZipUtils.generateZipByte((List)list);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=UserCert_" + applyNo + ".zip");
            out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7528\u6237\u7533\u8bf7\u7684\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception e) {
                this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        this.logger.info("CertApplyController.genUserCertByP10>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return null;
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/{applyNo}"}, method={RequestMethod.GET})
    public Object genUserCertRespByP10(@PathVariable String applyNo, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.genUserCertRespByP10>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.certApplyService.issueUserCertResp(applyNo, null, false);
        }
        catch (Exception e) {
            this.logger.error("\u4ee5P10\u7533\u8bf7\u4e66\u65b9\u5f0f\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7b7e\u53d1\u8bc1\u4e66\u54cd\u5e94\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7b7e\u53d1\u8bc1\u4e66\u54cd\u5e94\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertApplyController.genUserCertRespByP10>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/keystore/{applyType}/{certFormatType}/{applyNo}"}, method={RequestMethod.GET})
    public Object genUserCertByKeyStore(@PathVariable int applyType, @PathVariable String applyNo, @PathVariable int certFormatType, AuditSignBean bean, HttpServletResponse resp) throws Exception {
        Result result;
        this.logger.info("CertApplyController.genUserCertByKeyStore>>>>>>applyType:" + applyType + " certFormatType:" + certFormatType + " applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (applyType != 1 && applyType != 2 && applyType != 4 || certFormatType != 1 && certFormatType != 2 && certFormatType != 3) {
            return ErrorEnum.CERT_APPLY_TYPE_IS_ERROR.resp(resp);
        }
        try {
            result = this.certApplyService.issueUserCertByKeyStore(certFormatType, applyNo, applyType, false, null);
        }
        catch (Exception e) {
            this.logger.error("\u4ee5keyStore\u65b9\u5f0f\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        String applyTypeStr = null;
        switch (applyType) {
            case 1: {
                applyTypeStr = "\u7b7e\u53d1\u7533\u8bf7";
                break;
            }
            case 2: {
                applyTypeStr = "\u66f4\u65b0\u7533\u8bf7";
                break;
            }
            case 4: {
                applyTypeStr = "\u6062\u590d\u7533\u8bf7";
                break;
            }
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4ee5keyStore\u65b9\u5f0f\u7b7e\u53d1\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr);
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4ee5keyStore\u65b9\u5f0f\u7b7e\u53d1\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7533\u8bf7\u7f16\u53f7=").append(applyNo).append("\uff0c\u7533\u8bf7\u7c7b\u578b=").append(applyTypeStr);
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        try {
            List list = (List)result.getInfo();
            byte[] data = ZipUtils.generateZipByte((List)list);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=UserCert_" + applyNo + ".zip");
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7528\u6237\u7533\u8bf7\u7684\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        this.logger.info("CertApplyController.genUserCertByP10>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return null;
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/issue/keystore/batch"}, method={RequestMethod.POST})
    public Object genBatchKeyStore(@RequestParam(value="applyIds") String applyIds, AuditSignBean bean, HttpServletResponse resp) throws Exception {
        Result result;
        this.logger.info("CertApplyController.genBatchKeyStore>>>>>>start");
        this.logger.info("CertApplyController.genBatchKeyStore>>>>>>applyIds{}", (Object)applyIds);
        try {
            result = this.certApplyService.issueUserCertBatch(applyIds);
        }
        catch (Exception e) {
            this.logger.error("\u4ee5keyStore\u65b9\u5f0f\u6279\u91cf\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4ee5keyStore\u65b9\u5f0f\u6279\u91cf\u7b7e\u53d1\u8bc1\u4e66\u3010\u5931\u8d25\u3011").append(result.getLogContent());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4ee5keyStore\u65b9\u5f0f\u6279\u91cf\u7b7e\u53d1\u8bc1\u4e66\u3010\u6210\u529f\u3011").append(result.getLogContent());
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_ISSUE.type, logContent.toString(), logResult, bean.getSign());
        try {
            byte[] data = (byte[])result.getInfo();
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=UserCertBatch_" + System.currentTimeMillis() + ".zip");
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7528\u6237\u7533\u8bf7\u7684\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        this.logger.info("CertApplyController.genBatchKeyStore>>>>>>end");
        return null;
    }

    @RequestMapping(value={"/v1/user/cert/status/{applyNo}"}, method={RequestMethod.GET})
    public Object getUserCertStatus(@PathVariable String applyNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.getUserCertStatus>>>>>> applyNo:" + applyNo);
        try {
            result = this.certApplyService.getUserCertStatus(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.getUserCertStatus>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @Deprecated
    @RequestMapping(value={"/v1/user/cert/issue/p10/download/{applyNo}"}, method={RequestMethod.POST})
    public void downloadP10UserCert(@PathVariable String applyNo, @RequestBody String userCertInfo, HttpServletResponse resp) throws Exception {
        this.logger.info("CertApplyController.downloadP10UserCert>>>>>>applyNo:" + applyNo);
        try {
            Result result = this.certApplyService.formatUserCertInfo(userCertInfo);
            List list = (List)result.getInfo();
            byte[] data = ZipUtils.generateZipByte((List)list);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=userCert_" + applyNo + ".zip");
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u7528\u6237\u7533\u8bf7\u7684\u7528\u6237\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new Exception(e);
        }
        this.logger.info("CertApplyController.downloadP10UserCert>>>>>>applyNo:" + applyNo);
    }

    @Deprecated
    @RequestMapping(value={"/v1/user/cert/download/{applyNo}"}, method={RequestMethod.GET})
    public Object downloadUserCert(@PathVariable String applyNo, HttpServletResponse resp) {
        this.logger.info("CertApplyController.downloadUserCert>>>>>> applyNo:" + applyNo);
        try {
            String zipPath = "/home/userCert/issue/" + applyNo;
            String fileName = "\u7528\u6237\u7533\u8bf7\u8bc1\u4e66\uff1a" + applyNo + ".zip";
            byte[] data = ZipUtils.createZipByFile((String)zipPath, (String)fileName);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            ServletOutputStream out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fazip\u538b\u7f29\u5305\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return ErrorEnum.MAKE_ZIP_FILE_EXCEPTION.resp(resp);
        }
        this.logger.info("CertApplyController.downloadUserCert>>>>>>end");
        return null;
    }

    @RequestMapping(value={"/v1/user/cert/error/{applyNo}"}, method={RequestMethod.POST})
    public Object genErrorMsgContent(@PathVariable String applyNo, @Valid @RequestBody ErrorMsgReq errorMsgReq, BindingResult bindResult, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.genErrorMsgContent>>>>>>applyNo:" + applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u9001\u9519\u8bef\u54cd\u5e94\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.certApplyService.genErrorMsgContent(applyNo, errorMsgReq.getErrorCode(), errorMsgReq.getErrorMsg(), false);
        }
        catch (Exception e) {
            this.logger.error("\u9519\u8bef-\u54cd\u5e94-\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.raSdkCache.removeCaTransId(applyNo);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.genErrorMsgContent>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/parse/p10"}, method={RequestMethod.POST})
    public Object parserDnFromP10(@RequestPart(value="cmf") MultipartFile cmf, HttpServletResponse resp) {
        String certDn;
        if (cmf.isEmpty()) {
            this.logger.warn("[CertApplyController#parserDnFromP10] applyNo{} req param [cmf] null check error.");
            return ErrorEnum.ISSUE_APPLY_P10_FILE_IS_EMPTY.resp(resp);
        }
        try {
            String userP10Str = IOUtils.toString((byte[])cmf.getBytes(), (String)"UTF-8");
            certDn = SdkP10Utils.p10ToCertDn((String)userP10Str);
            this.logger.info("[CertApplyController#parserDnFromP10]>>>>>>applyNo:{} parser P10's certDn:{}", (Object)certDn);
        }
        catch (IOException e) {
            this.logger.warn("[CertApplyController#parserDnFromP10] parser P10 have IOException.", (Throwable)e);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        return Result.success((Object)certDn);
    }

    @RequestMapping(value={"/v1/user/cert/container"}, method={RequestMethod.POST})
    public Object defaultContainer(@RequestBody Container container, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.defaultContainer>>>>>>defaultContainer:{}", (Object)container);
        String defaultContainer = container.getDefaultContainer();
        if (StringUtils.isBlank((CharSequence)defaultContainer)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.certApplyService.defaultContainer(defaultContainer);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u9ed8\u8ba4\u5bb9\u5668\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.defaultContainer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/cert/container"}, method={RequestMethod.GET})
    public Object getDefaultContainer(HttpServletResponse resp) {
        Result result;
        this.logger.info("CertApplyController.getDefaultContainer>>>>>>start");
        try {
            result = this.certApplyService.getDefaultContainer();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u9ed8\u8ba4\u5bb9\u5668\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertApplyController.getDefaultContainer>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

