/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.certapply;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import com.xdja.pki.ra.service.manager.certapply.FreezeApplyService;
import com.xdja.pki.ra.web.manager.certapply.bean.FreezeApplyReq;
import com.xdja.pki.ra.web.manager.certapply.bean.UnFreezeApplyReq;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FreezeCertApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FreezeApplyService freezeApplyService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/user/cert/apply/freeze/{applyNo}"}, method={RequestMethod.GET})
    public Object getFreezeCertApplyInfo(@PathVariable String applyNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("FreezeCertApplyController.getFreezeCertApplyInfo>>>>>>applyNo:{}", (Object)applyNo);
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.freezeApplyService.getFreezeApplyInfo(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u51bb\u7ed3/\u89e3\u51bb\u8bc1\u4e66\u7533\u8bf7\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("FreezeCertApplyController.getFreezeCertApplyInfo>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/freeze"}, method={RequestMethod.POST})
    public Object insertUserCertFreezeApply(@Valid @RequestBody FreezeApplyReq freezeApplyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("FreezeCertApplyController.insertUserCertFreezeApply>>>>>>freezeApplyReq:" + JsonUtils.object2Json((Object)freezeApplyReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u8d77\u51bb\u7ed3\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        FreezeApplyDTO freezeApplyDTO = new FreezeApplyDTO();
        BeanUtils.copyProperties((Object)freezeApplyReq, (Object)freezeApplyDTO);
        freezeApplyDTO.setApplyType(Integer.valueOf(ApplyTypeEnum.FREEZE_APPLY.id));
        freezeApplyDTO.setApplyReason(freezeApplyReq.getFreezeReason());
        Result result = this.freezeApplyService.insertUserCertFreezeApply(null, freezeApplyDTO, false, false);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u51bb\u7ed3\u7533\u8bf7\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(freezeApplyReq.getCertDn());
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u51bb\u7ed3\u7533\u8bf7\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(freezeApplyReq.getCertDn());
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("FreezeCertApplyController.insertUserCertFreezeApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/cert/apply/unfreeze"}, method={RequestMethod.POST})
    public Object insertUserCertUnFreezeApply(@Valid @RequestBody UnFreezeApplyReq unFreezeApplyReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("FreezeCertApplyController.insertUserCertFreezeApply>>>>>>unFreezeApplyReq:" + JsonUtils.object2Json((Object)unFreezeApplyReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u8d77\u89e3\u51bb\u8bc1\u4e66\u7533\u8bf7\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        FreezeApplyDTO freezeApplyDTO = new FreezeApplyDTO();
        BeanUtils.copyProperties((Object)unFreezeApplyReq, (Object)freezeApplyDTO);
        freezeApplyDTO.setApplyType(Integer.valueOf(ApplyTypeEnum.UNFREEZE_APPLY.id));
        freezeApplyDTO.setApplyReason(unFreezeApplyReq.getUnfreezeReason());
        Result result = this.freezeApplyService.insertUserCertFreezeApply(null, freezeApplyDTO, false, false);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u89e3\u51bb\u7533\u8bf7\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(unFreezeApplyReq.getCertDn());
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u53d1\u8d77\u7528\u6237\u8bc1\u4e66\u89e3\u51bb\u7533\u8bf7\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66\u4e3b\u4f53=").append(unFreezeApplyReq.getCertDn());
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.SUBMIT_APPLY.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("FreezeCertApplyController.insertUserCertFreezeApply>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

