/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.login;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.login.AdminLoginService;
import com.xdja.pki.ra.web.manager.login.bean.AdminLoginReq;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminLoginController {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AdminLoginService adminLoginService;
    @Autowired
    AuditLogService auditLogService;

    @AuditSign
    @RequestMapping(value={"/v1/login/manager"}, method={RequestMethod.POST})
    public Object login(@Valid @RequestBody AdminLoginReq adminLoginReq, BindingResult bindingResult, AuditSignBean bean, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.info("AdminLoginController.login>>>>>>" + JsonUtils.object2Json((Object)adminLoginReq));
        if (adminLoginReq == null || bindingResult.hasErrors()) {
            this.logger.info("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef:" + bindingResult.getAllErrors().toString());
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        String clientIpAddress = this.getClientIpAddress(request);
        this.logger.info("\u5ba2\u6237\u7aef\u7684ip\u5730\u5740\u4e3a\uff1a" + clientIpAddress);
        Result result = this.adminLoginService.managerLogin(adminLoginReq.getCardNo(), adminLoginReq.getSn(), adminLoginReq.getSignData(), clientIpAddress, bean);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u3010\u5931\u8d25\u3011\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_LOGIN.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
        this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_LOGIN.type, logContent.toString(), logResult, bean.getSign());
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/login/challenge/{signSn}"}, method={RequestMethod.GET})
    public Object getChallenge(@PathVariable String signSn, HttpServletResponse resp) {
        this.logger.info("AdminLoginController.getChallenge>>>>>> signSn " + signSn);
        if (StringUtils.isBlank((CharSequence)signSn)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = this.adminLoginService.generateChallenge(signSn);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/logout"}, method={RequestMethod.GET})
    public void logout(AuditSignBean bean) {
        this.logger.info("LoginController.logout>>>>>>start!");
        Operator operator = OperatorUtil.getOperator();
        if (operator != null && operator.getCurrUser() != null) {
            this.logger.info("========== " + operator.getCurrUser());
            String sessionId = (String)SecurityUtils.getSubject().getSession().getAttribute((Object)"sessionId");
            this.logger.info("LoginController.logout>>>>>>sessionId:" + sessionId);
            StringBuilder logContent = new StringBuilder();
            logContent.append("\u7ba1\u7406\u5458\u9000\u51fa\u7cfb\u7edf\u3010\u6210\u529f\u3011\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_LOGIN.type, logContent.toString(), AuditLogResultEnum.SUCCESS.id, bean.getSign());
        }
        SecurityUtils.getSubject().logout();
        this.logger.info("LoginController.logout>>>>>>no login user");
    }

    protected String getClientIpAddress(HttpServletRequest request) {
        String clientIp = request.getHeader("x-forwarded-for");
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        return clientIp;
    }
}

