/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.statistics;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.file.ExcelUtil;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.statistics.StatisticsService;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StatisticsController {
    @Autowired
    StatisticsService statisticsService;
    private Logger logger = LoggerFactory.getLogger(StatisticsController.class);

    @GetMapping(value={"/v1/statistics/customer/query"})
    public Object statisticsCustomerCert(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="customerSysName", required=false) String customerSysName, HttpServletResponse resp) {
        this.logger.info("StatisticsController.statisticsCustomerCert>>>>>>startTime:" + startTime + " endTime:" + endTime + " customerSysName:" + customerSysName);
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.debug("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62e5\u6709\u8bc1\u4e66\u7edf\u8ba1\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.statisticsService.getCustomerCertStatistics(customerSysName, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62e5\u6709\u8bc1\u4e66\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/customer/export"})
    public Object statisticsCustomerCertExport(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="customerSysName", required=false) String customerSysName, HttpServletResponse resp) {
        this.logger.info("StatisticsController.statisticsCustomerCertExport>>>>>>startTime:{},endTime:{},customerSysName:{}", new Object[]{startTime, endTime, customerSysName});
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u7edf\u8ba1\u5bfc\u51fa\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List datas = this.statisticsService.getCustomerCertStatistics(customerSysName, startTime, endTime);
            if (datas.isEmpty()) {
                return null;
            }
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=cert_institution_list.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u7b2c\u4e09\u65b9\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1", (List)datas, (boolean)true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62e5\u6709\u8bc1\u4e66\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"v1/statistics/cert"})
    public Object statisticsCert(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="certTemplateName", required=false) String certTemplateName, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.debug("\u83b7\u53d6\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.statisticsService.getCertStatistics(certTemplateName, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/templateName"})
    public Object getCertTemplate(HttpServletResponse resp) {
        try {
            return this.statisticsService.getCertTemplate();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u540d\u79f0\u5217\u8868 \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"v1/statistics/cert/export"})
    public Object statisticsCertExport(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="certTemplateName", required=false) String certTemplateName, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.debug("\u5bfc\u51fa\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List datas = this.statisticsService.getCertStatistics(certTemplateName, startTime, endTime);
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=cert_statistics_list.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1\u5217\u8868", (List)datas, (boolean)true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"v1/statistics/ra"})
    public Object statisticsUser(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.debug("\u83b7\u53d6\u7528\u6237\u6570\u91cf\u7edf\u8ba1 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List userStatistics = this.statisticsService.getUserStatistics(startTime, endTime);
            this.logger.info("StatisticsController.statisticsUserExport>>>>>>result:" + JsonUtils.object2Json((Object)userStatistics));
            return userStatistics;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u6570\u91cf\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/ra/export"})
    public Object statisticsUserExport(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime) || StringUtils.isBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            this.logger.debug("\u5bfc\u51fa\u7528\u6237\u6570\u91cf\u7edf\u8ba1 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List datas = this.statisticsService.getUserStatistics(startTime, endTime);
            this.logger.info("StatisticsController.statisticsUserExport>>>>>>result:" + JsonUtils.object2Json((Object)datas));
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=user_statistics_list.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u7528\u6237\u6570\u91cf\u7edf\u8ba1\u5217\u8868", (List)datas, (boolean)true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u7528\u6237\u6570\u91cf\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

