/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.system;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.system.HsmServer;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class HsmController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    HsmServer hsmServer;
    @Autowired
    AuditLogService auditLogService;

    @Deprecated
    @RequestMapping(value={"/v1/system/hsm/connect/status"}, method={RequestMethod.GET})
    public Object initTestHsmController(HttpServletResponse resp) {
        this.logger.info("HsmController.initTestHsmController>>>>>>>>>>>>>>>>>>>>>>>>>>");
        Result result = this.hsmServer.testHsmConnect();
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/system/hsm/config"}, method={RequestMethod.POST})
    public Object updateHsmDetailsController(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="certChain", required=false) MultipartFile certChain, @RequestParam(value="signCert", required=false) MultipartFile sign, @RequestParam(value="enc", required=false) MultipartFile enc, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("SystemController.updateHsmDetailsController>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " encCertPwd\uff1a " + encCertPwd + " signCertPwd\uff1a " + signCertPwd);
        Result result = this.hsmServer.initHsmServer(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, sign, enc, certChain);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u5bc6\u7801\u673a\u670d\u52a1\u914d\u7f6e\u3010\u5931\u8d25\u3011\uff0c\u5bc6\u7801\u673a\u670d\u52a1IP=").append(hsmServerIp).append("\uff0c\u5bc6\u7801\u673a\u670d\u52a1\u7aef\u53e3=").append(hsmServerPort).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u5bc6\u7801\u673a\u670d\u52a1\u914d\u7f6e\u3010\u6210\u529f\u3011\uff0c\u5bc6\u7801\u673a\u670d\u52a1IP=").append(hsmServerIp).append("\uff0c\u5bc6\u7801\u673a\u670d\u52a1\u7aef\u53e3=").append(hsmServerPort);
        this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @RequestMapping(value={"/v1/system/hsm/config/connect"}, method={RequestMethod.POST})
    public Object systemTestHsmController(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="sign", required=false) MultipartFile sign, @RequestParam(value="enc", required=false) MultipartFile enc, @RequestParam(value="certChain", required=false) MultipartFile certChain, HttpServletResponse resp) {
        this.logger.info("SystemController.systemTestHsmController>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " encCertPwd\uff1a " + encCertPwd + " signCertPwd\uff1a " + signCertPwd);
        Result result = this.hsmServer.testHsmConnect(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, sign, enc, certChain);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("\u5bc6\u7801\u673a\u521d\u59cb\u5316\u8fde\u63a5\u6d4b\u8bd5\uff1a\u5bc6\u7801\u673a\u8fde\u63a5\u6210\u529f\u300b\u300b\u300b\u300b\u300b\u300b");
        result.setInfo((Object)1);
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/system/swxahsm/config"}, method={RequestMethod.POST})
    public Object updateSwxaHsm(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="accessPassword") String accessPassword, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("HsmController.updateSwxaHsm>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " accessPassword\uff1a " + accessPassword);
        Result result = this.hsmServer.saveSwxaHsm(hsmServerIp, hsmServerPort, accessPassword, true);
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u5bc6\u7801\u673a\u670d\u52a1\u914d\u7f6e\u3010\u5931\u8d25\u3011\uff0c\u5bc6\u7801\u673a\u670d\u52a1IP=").append(hsmServerIp).append("\uff0c\u5bc6\u7801\u673a\u670d\u52a1\u7aef\u53e3=").append(hsmServerPort).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u5bc6\u7801\u673a\u670d\u52a1\u914d\u7f6e\u3010\u6210\u529f\u3011\uff0c\u5bc6\u7801\u673a\u670d\u52a1IP=").append(hsmServerIp).append("\uff0c\u5bc6\u7801\u673a\u670d\u52a1\u7aef\u53e3=").append(hsmServerPort);
        this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @RequestMapping(value={"/v1/system/swxahsm/connect"}, method={RequestMethod.POST})
    public Object testSwxaHsm(@RequestParam(value="hsmServerIp") String hsmServerIp, @RequestParam(value="hsmServerPort") int hsmServerPort, @RequestParam(value="accessPassword") String accessPassword, HttpServletResponse resp) {
        this.logger.info("HsmController.testSwxaHsm>>>>>>hsmServerIp  " + hsmServerIp + "  hsmServerPort: " + hsmServerPort + " accessPassword\uff1a " + accessPassword);
        Result result = this.hsmServer.testSwxaHsmConnect(hsmServerIp, hsmServerPort, accessPassword, true);
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("SWXA-\u5bc6\u7801\u673a\u521d\u59cb\u5316\u8fde\u63a5\u6d4b\u8bd5\uff1a\u5bc6\u7801\u673a\u8fde\u63a5\u6210\u529f\u300b\u300b\u300b\u300b\u300b\u300b");
        result.setInfo((Object)1);
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/hsm/config/info"}, method={RequestMethod.GET})
    public Object getHsmDetails(HttpServletResponse resp) {
        Result result;
        this.logger.info("HsmController.getHsmDetails>>>>>>>>>>>>>>>>>>>>>>>>>>");
        try {
            result = this.hsmServer.getHsmInfo();
        }
        catch (Exception e) {
            this.logger.info("\u8bfb\u53d6\u5bc6\u7801\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.HSM_GET_DETAILS_ERROR.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("HsmController.getHsmDetails>>>>>>result :" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

