/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.template;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.system.RaServer;
import com.xdja.pki.ra.service.manager.template.CertTempService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CertTempController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertTempService certTempService;
    @Autowired
    RaServer raService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/manager/temp"}, method={RequestMethod.GET})
    public Object listCertTemplate(@RequestParam(value="tempName", required=false) String tempName, @RequestParam(value="tempStatus", required=false) Integer tempStatus, @RequestParam(value="userCA", required=false) String userCA, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.listCertTemplate>>>>>>tempName:{},tempStatus:{},userCA:{},pageNo:{},pageSize:{} ", new Object[]{tempName, tempStatus, userCA, pageNo, pageSize});
        if (tempStatus == null || tempStatus > 3) {
            tempStatus = 0;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.certTempService.listCertTemplate(tempName, tempStatus.intValue(), pageNo, pageSize, userCA);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertTempController.listCertTemplate>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/temp_syn"}, method={RequestMethod.GET})
    public Object synCertTemplateList(@RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.synCertTemplateList>>>>>> pageNo:{}\uff0c pageSize:{}", (Object)pageNo, (Object)pageSize);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.certTempService.synCertTemplateList(pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u6a21\u677f\u4fe1\u606f\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u540c\u6b65\u8bc1\u4e66\u6a21\u677f\u3010\u5931\u8d25\u3011").append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.TEMPLATE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u540c\u6b65\u8bc1\u4e66\u6a21\u677f\u3010\u6210\u529f\u3011");
        this.auditLogService.save(AuditLogOperatorTypeEnum.TEMPLATE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertTempController.synCertTemplateList>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result.getInfo()));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/temp/{tempNo}"}, method={RequestMethod.GET})
    public Object getCertTemplateInfo(@PathVariable(value="tempNo") String tempNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.getCertTemplateInfo>>>>>> tempNo:" + tempNo);
        if (StringUtils.isBlank((CharSequence)tempNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.caBusinessManager.getCertTemplateDetailInfoByTempNo(tempNo);
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertTempController.getCertTemplateInfo>>>>>>result:" + JsonUtils.object2Json((Object)result.getInfo()));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/manager/temp/{tempNo}/{checkStrategy}"}, method={RequestMethod.PUT})
    public Object updateCertTempCheckStrategy(@PathVariable(value="tempNo") String tempNo, @PathVariable(value="checkStrategy") int checkStrategy, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.updateCertTempCheckStrategy>>>>>> tempNo:" + tempNo + " checkStrategy:" + checkStrategy);
        if (StringUtils.isBlank((CharSequence)tempNo)) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (1 != checkStrategy && 2 != checkStrategy) {
            return ErrorEnum.CERT_TEMP_CHECK_STRATEGY_TYPE_IS_ERROR.resp(resp);
        }
        try {
            result = this.certTempService.updateCertTempCheckStrategy(tempNo, checkStrategy);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u6a21\u677f\u5ba1\u6838\u7b56\u7565\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u8bc1\u4e66\u6a21\u677f\u5ba1\u6838\u7b56\u7565\u3010\u5931\u8d25\u3011\uff0c").append("\u6a21\u677f\u7f16\u53f7=").append(tempNo).append(result.getLogContent()).append("\uff0c\u5ba1\u6838\u7b56\u7565=").append(checkStrategy == 1 ? "\u81ea\u52a8" : "\u4eba\u5de5").append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.TEMPLATE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u8bc1\u4e66\u6a21\u677f\u5ba1\u6838\u7b56\u7565\u3010\u6210\u529f\u3011\uff0c").append("\u6a21\u677f\u7f16\u53f7=").append(tempNo).append(result.getLogContent()).append("\uff0c\u5ba1\u6838\u7b56\u7565=").append(checkStrategy == 1 ? "\u81ea\u52a8" : "\u4eba\u5de5");
        this.auditLogService.save(AuditLogOperatorTypeEnum.TEMPLATE_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("CertTempController.updateCertTempCheckStrategy>>>>>>result:" + JsonUtils.object2Json((Object)result.getInfo()));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/temp_list"}, method={RequestMethod.GET})
    public Object listCertTemplateDropDownList(@RequestParam(value="userCA", required=false) String userCA, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.listCertTemplateDropDownList>>>>>>userCA:{}", (Object)userCA);
        try {
            result = this.certTempService.listCertTemplateDropDownList(userCA);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        this.logger.info("CertTempController.listCertTemplateDropDownList>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/manager/validity/{tempNo}"}, method={RequestMethod.GET})
    public Object getCertApplyMaxValidity(@PathVariable(value="tempNo") String tempNo, @RequestParam(value="updateKey", required=false) Integer updateKey, @RequestParam(value="signSn", required=false) String signSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("CertTempController.getCertApplyMaxValidity>>>>>>tempNo:" + tempNo + " updateKey:" + updateKey + " signSn:" + signSn);
        if (updateKey == null) {
            updateKey = 1;
        }
        if (updateKey == 0 && signSn == null) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            result = this.certTempService.getCertApplyMaxValidity(tempNo, updateKey.intValue(), signSn, false);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u6700\u5927\u6709\u6548\u671f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("CertTempController.getCertApplyMaxValidity>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

