/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.user;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceInfo;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DeviceUserController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DeviceUserService deviceUserService;
    @Autowired
    PersonUserService personUserService;
    @Autowired
    AuditLogService auditLogService;

    @AuditSign
    @RequestMapping(value={"/v1/user/device/save/one"}, method={RequestMethod.POST})
    public Object saveDeviceUser(@Valid @RequestBody DeviceInfo deviceUserInfo, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("DeviceUserController.saveDeviceUser>>>>>>deviceUserInfo:" + JsonUtils.object2Json((Object)deviceUserInfo));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u8bbe\u5907\u7528\u6237\u6ce8\u518c\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.deviceUserService.registerDeviceUser(deviceUserInfo.getDeviceUserInfo(), deviceUserInfo.getUserInfo(), false);
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u5907\u7528\u6237\u6ce8\u518c\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u8bbe\u5907\u7528\u6237\u6ce8\u518c\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u8bbe\u5907\u7528\u6237 ");
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u8bbe\u5907\u7528\u6237\u6ce8\u518c\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u8bbe\u5907\u7528\u6237 ");
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("DeviceUserController.saveDeviceUser>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result;
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/device/{deviceId}"}, method={RequestMethod.POST})
    public Object updateDeviceUserInfo(@PathVariable long deviceId, @Valid @RequestBody DeviceInfo deviceInfo, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.info("DeviceUserController.updateDeviceUserInfo>>>>>>deviceId :" + deviceId);
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u8bbe\u5907\u7528\u6237\u4fee\u6539\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = new Result();
        try {
            result = this.deviceUserService.updateDeviceUser(deviceId, deviceInfo.getDeviceUserInfo(), deviceInfo.getUserInfo());
        }
        catch (Exception e) {
            result.setError(ErrorEnum.SERVER_INTERNAL_EXCEPTION);
            return result;
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess() && null != result.getError()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u8bbe\u5907\u7528\u6237\u4fe1\u606f\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u8bbe\u5907\u7528\u6237");
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u8bbe\u5907\u7528\u6237\u4fe1\u606f\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u8bbe\u5907\u7528\u6237");
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        return result;
    }

    @RequestMapping(value={"/v1/user/device/details/{deviceId}"}, method={RequestMethod.GET})
    public Object getDeviceUserInfo(@PathVariable(value="deviceId") long deviceId, HttpServletResponse resp) {
        this.logger.info("DeviceUserController.getDeviceUserInfo>>>>>>  deviceId :" + deviceId);
        Result result = this.deviceUserService.queryDeviceDetails(deviceId);
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("DeviceUserController.getDeviceUserInfo>>>>>>  result :" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/device/query"}, method={RequestMethod.GET})
    public Object queryDeviceUserList(@RequestParam(value="deviceName", required=false) String deviceName, @RequestParam(value="licenseNumber", required=false) String licenseNumber, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNo") int pageNo, HttpServletResponse resp) {
        Result result;
        this.logger.info("DeviceUserController.queryDeviceUserList>>>>>>deviceName:  " + deviceName + "  licenseNumber: " + licenseNumber + " status:" + status + " pageNo:" + pageNo + " pageSize:" + pageSize);
        if (status == null || status != 0 && status != 1) {
            status = -1;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.deviceUserService.listDeviceUser(deviceName, licenseNumber, status.intValue(), pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u7528\u6237\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        return result.getInfo();
    }
}

