/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.user;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserInfo;
import com.xdja.pki.ra.service.manager.personuser.bean.SavePersonUserVO;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PersonUserController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    PersonUserService personUserService;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/user/person/query"}, method={RequestMethod.GET})
    public Object queryPersonUserList(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="licenseNumber", required=false) String licenseNumber, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, HttpServletResponse resp) {
        Result result;
        this.logger.info("PersonUserController.queryPersonUserList>>>>>>userName:" + userName + " licenseNumber:" + licenseNumber + " status:" + status + " pageNo:" + pageNo + " pageSize:" + pageSize);
        if (status == null || status != 0 && status != 1) {
            status = -1;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        try {
            result = this.personUserService.listPersonUser(userName, licenseNumber, status.intValue(), pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u4e2a\u4eba\u7528\u6237\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.debug("PersonUserController.queryPersonUserList>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/person/details/{personId}"}, method={RequestMethod.GET})
    public Object getPersonUserInfo(@PathVariable(value="personId") long personId, HttpServletResponse resp) {
        this.logger.info("PersonUserController.getPersonUserInfo>>>>>>personId\uff1a" + personId);
        Result result = this.personUserService.getPersonUserDetails(personId);
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("PersonUserController.getPersonUserInfo>>>>>>result\uff1a" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/person/update/{personId}"}, method={RequestMethod.POST})
    public Object updatePersonUserInfo(@PathVariable(value="personId") int personId, @Valid @RequestBody PersonUserInfo personUserInfo, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("PersonUserController.updatePersonUserInfo>>>>>>personId\uff1a" + personId + "personUserInfo : " + JsonUtils.object2Json((Object)personUserInfo));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u4e2a\u4eba\u7528\u6237\u4fee\u6539\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.personUserService.updatePersonUser(personId, personUserInfo);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4fee\u6539\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u4e2a\u4eba\u7528\u6237").append("\uff0c\u7528\u6237ID=" + personId).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4fee\u6539\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u4e2a\u4eba\u7528\u6237").append("\uff0c\u7528\u6237ID=" + personId);
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("PersonUserController.updatePersonUserInfo>>>>>>result\uff1a" + JsonUtils.object2Json((Object)result));
        return result;
    }

    @AuditSign
    @RequestMapping(value={"/v1/user/person/save/one"}, method={RequestMethod.POST})
    public Object savePersonUser(@Valid @RequestBody SavePersonUserVO savePersonUserVO, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("PersonUserController.savePersonUser>>>>>>personUserInfoVO:" + JsonUtils.object2Json((Object)savePersonUserVO));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u4e2a\u4eba\u7528\u6237\u6ce8\u518c\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        PersonUserDTO personUserDTO = new PersonUserDTO();
        BeanUtils.copyProperties((Object)savePersonUserVO, (Object)personUserDTO);
        try {
            result = this.personUserService.savePersonUser(personUserDTO);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4e2a\u4eba\u7528\u6237\u6ce8\u518c\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u4e2a\u4eba\u7528\u6237");
            if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
                logContent.append(result.getLogContent());
            }
            logContent.append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4e2a\u4eba\u7528\u6237\u6ce8\u518c\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7c7b\u578b=").append("\u4e2a\u4eba\u7528\u6237");
        if (StringUtils.isNotBlank((CharSequence)result.getLogContent())) {
            logContent.append(result.getLogContent());
        }
        this.auditLogService.save(AuditLogOperatorTypeEnum.USER_MANAGER.type, logContent.toString(), logResult, bean.getSign());
        this.logger.info("PersonUserController.savePersonUser>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result;
    }
}

