/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.web.manager.usercert;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.ErrorBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.service.manager.cert.CertService;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserCertController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserCertService userCertService;
    @Autowired
    CertService certService;
    @Autowired
    AuditLogService auditLogService;

    @RequestMapping(value={"/v1/user/certs"}, method={RequestMethod.GET})
    public Object listUserCert(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="certDn", required=false) String certDn, @RequestParam(value="userCA", required=false) String userCA, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="leftDate", required=false) Integer leftDate, @RequestParam(value="effectiveTimeAsc", required=false) Boolean effectiveTimeAsc, @RequestParam(value="failureTimeAsc", required=false) Boolean failureTimeAsc, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        Result result;
        this.logger.info("UserCertController.listUserCert>>>>>>userName:{}, leftDate:{},certDn:{},userCA:{},pageNo:{},pageSize:{}", new Object[]{userName, leftDate, certDn, userCA, pageNo, pageSize});
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (null == leftDate || leftDate <= 0) {
            leftDate = 0;
        }
        try {
            result = this.userCertService.listUserCertNew(certDn, userName, userCA, pageNo, pageSize, leftDate.intValue(), effectiveTimeAsc, failureTimeAsc, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess() && null != result.getError()) {
            return result.resp(resp, result);
        }
        this.logger.info("UserCertController.listUserCert>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/user/certs/{certSn}"}, method={RequestMethod.GET})
    public Object getUserCertInfo(@PathVariable String certSn, HttpServletResponse resp) {
        Result result;
        this.logger.info("UserCertController.getUserCertInfo>>>>>> certSn:" + certSn);
        try {
            result = this.certService.getCertDetailInfo(certSn);
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("UserCertController.getUserCertInfo>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditSign
    @RequestMapping(value={"/v1/user/certs/file/{certSn}"}, method={RequestMethod.GET})
    public Object exportUserDoubleCerts(@PathVariable String certSn, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("UserCertController.exportUserDoubleCerts>>>>>> certSn:" + certSn);
        try {
            result = this.userCertService.exportUserDoubleCerts(certSn);
        }
        catch (Exception e) {
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            int logResult = AuditLogResultEnum.FAIL.id;
            logContent.append("\u4e0b\u8f7d\u7528\u6237\u8bc1\u4e66\u3010\u5931\u8d25\u3011\uff0c\u7528\u6237\u7b7e\u540d\u8bc1\u4e66SN=").append(certSn).append("\uff0c\u5931\u8d25\u539f\u56e0=").append(result.getErrorBean().getErrMsg());
            this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_DOWNLOAD.type, logContent.toString(), logResult, bean.getSign());
            return result.resp(resp, result);
        }
        int logResult = AuditLogResultEnum.SUCCESS.id;
        logContent.append("\u4e0b\u8f7d\u7528\u6237\u8bc1\u4e66\u3010\u6210\u529f\u3011\uff0c\u7528\u6237\u7b7e\u540d\u8bc1\u4e66SN=").append(certSn);
        this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_DOWNLOAD.type, logContent.toString(), logResult, bean.getSign());
        OutputStream out = null;
        try {
            List list = (List)result.getInfo();
            byte[] data = ZipUtils.generateZipByte((List)list);
            resp.setContentType("application/octet-stream");
            resp.setCharacterEncoding("UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=UserCert_" + certSn + ".zip");
            out = resp.getOutputStream();
            IOUtils.write((byte[])data, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fazip\u538b\u7f29\u5305\u5931\u8d25", (Throwable)e);
            ErrorBean errorBean = ErrorEnum.MAKE_ZIP_FILE_EXCEPTION.resp(resp);
            return errorBean;
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception e) {
                this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        this.logger.info("UserCertController.exportUserDoubleCerts>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result.getInfo();
    }
}

