/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.security;

import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.security.bean.Menu;
import com.xdja.pki.ra.security.filter.CustomAuthorizationFilter;
import com.xdja.pki.ra.security.filter.KickoutSessionControlFilter;
import com.xdja.pki.ra.security.filter.SessionTimeoutFilter;
import com.xdja.pki.ra.security.realm.CustomShiroRealm;
import com.xdja.pki.ra.security.service.SecurityService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SecurityService securityService;

    @Bean
    public CustomShiroRealm customShiroRealm() {
        return new CustomShiroRealm(this.securityService);
    }

    @Bean
    public SessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO(this.sessionDAO());
        sessionManager.setGlobalSessionTimeout(1800000L);
        return sessionManager;
    }

    @Bean
    public SessionDAO sessionDAO() {
        return new MemorySessionDAO();
    }

    @Bean
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.customShiroRealm());
        securityManager.setSessionManager(this.sessionManager());
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean() {
        this.logger.info("Shiro\u6743\u9650\u52a0\u8f7d ========== \u5f00\u59cb");
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(this.securityManager());
        LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
        filters.put("authc", (Object)new SessionTimeoutFilter(this.securityService));
        filters.put("kickout", (Object)new KickoutSessionControlFilter(this.securityService));
        filters.put("perms", (Object)new CustomAuthorizationFilter(this.securityService));
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitions = new LinkedHashMap<String, String>();
        Collection<String> whiteLinks = this.securityService.getWhiteLink();
        if (null != whiteLinks && !whiteLinks.isEmpty()) {
            for (String link : whiteLinks) {
                filterChainDefinitions.put(link, "anon");
            }
        }
        this.processPermission(filterChainDefinitions, this.securityService.getFunctions());
        filterChainDefinitions.put("/**", "kickout, authc, perms");
        this.logger.info("\u8fc7\u6ee4\u5668\u62e6\u622a\u5b9a\u4e49\u96c6\u5408 ========== " + JsonUtils.object2Json(filterChainDefinitions));
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitions);
        this.logger.info("Shiro\u6743\u9650\u52a0\u8f7d ========== \u5b8c\u6210");
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(this.securityManager());
        return authorizationAttributeSourceAdvisor;
    }

    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Menu> menus) {
        if (null != menus && !menus.isEmpty()) {
            for (Menu menu : menus) {
                if (StringUtils.isNotBlank((CharSequence)menu.getName()) && StringUtils.isNotBlank((CharSequence)menu.getPermission())) {
                    filterChainDefinitions.put(menu.getPermissionKey(), "perms[" + menu.getPermission() + "]");
                }
                this.processPermission(filterChainDefinitions, menu.getChildren());
            }
        }
    }
}

