/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.security.filter;

import com.xdja.pki.ra.security.service.SecurityService;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KickoutSessionControlFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(KickoutSessionControlFilter.class);
    private SecurityService securityService;

    public KickoutSessionControlFilter(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (!subject.isAuthenticated() && !subject.isRemembered()) {
            return true;
        }
        Session session = subject.getSession();
        if (session.getAttribute((Object)"kickout") != null) {
            try {
                subject.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (req.getHeader("x-requested-with") != null && req.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest")) {
                resp.setHeader("sessionstatus", "timeout");
                resp.setStatus(401);
                this.render(resp, this.securityService.unAuthenticationContent());
            } else {
                String loginUrl = this.getLoginUrl();
                this.saveRequest(request);
                resp.setStatus(401);
                this.render(resp, this.securityService.unAuthorizationContent());
            }
            return false;
        }
        return true;
    }

    private void render(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            log.error(String.format("Shiro\u81ea\u5b9a\u4e49\u6743\u9650\u8fc7\u6ee4\u5668\u54cd\u5e94Ajax\u8bf7\u6c42\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
        }
    }
}

