/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.security.realm;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.service.SecurityService;
import com.xdja.pki.ra.security.util.OperatorUtil;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomShiroRealm
extends AuthorizingRealm {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    SecurityService securityService;

    public CustomShiroRealm() {
    }

    public CustomShiroRealm(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Operator operator = OperatorUtil.getOperator();
        if (null != operator && !operator.getPermissions().isEmpty()) {
            info.addStringPermissions(operator.getPermissions());
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        com.xdja.pki.ra.security.bean.AuthenticationInfo authenticationInfo = this.securityService.doAuthen(authToken);
        if (null == authenticationInfo) {
            throw new AuthenticationException(String.valueOf(ErrorEnum.AUTHEN_INFO_IS_EMPTY));
        }
        this.logger.info("\u7ba1\u7406\u5458\u8ba4\u8bc1\u7ed3\u679c =========== " + JsonUtils.object2Json((Object)authenticationInfo));
        return new SimpleAuthenticationInfo((Object)authToken, (Object)"111111", this.getName());
    }
}

