/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.datacenter.jpa.dao;

import com.xdja.platform.datacenter.jpa.dao.annotation.ImportData;
import com.xdja.platform.datacenter.jpa.dao.annotation.Schema;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

abstract class AbstractBaseDaoTest {
    private static Logger log = LoggerFactory.getLogger(AbstractBaseDaoTest.class);

    AbstractBaseDaoTest() {
    }

    protected void initDb(DataSource dataSource) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Object[] sqlFiles = null;
        Schema schemaAnnon = this.getClass().getAnnotation(Schema.class);
        ImportData importAnnon = this.getClass().getAnnotation(ImportData.class);
        if (null != schemaAnnon && ArrayUtils.isNotEmpty((Object[])schemaAnnon.value())) {
            sqlFiles = (String[])ArrayUtils.addAll(sqlFiles, (Object[])schemaAnnon.value());
        }
        if (null != importAnnon && ArrayUtils.isNotEmpty((Object[])importAnnon.value())) {
            sqlFiles = (String[])ArrayUtils.addAll((Object[])sqlFiles, (Object[])importAnnon.value());
        }
        if (null == sqlFiles) {
            sqlFiles = new String[]{"*.sql"};
        }
        try {
            for (Object sqlFile : sqlFiles) {
                for (Resource resource : resolver.getResources("classpath:/" + (String)sqlFile)) {
                    populator.addScript(resource);
                }
            }
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d\u6570\u636e\u5e93\u521d\u59cb\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
    }
}

