/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.http;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.client.BaseClient;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpClient
extends BaseClient {
    private String url = null;
    private ResponseHandler<ResponseBean> handler = new ResponseHandler<ResponseBean>(){

        public ResponseBean handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                if (statusLine.getStatusCode() == 404) {
                    throw new RuntimeException("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728");
                }
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new RuntimeException("\u54cd\u5e94\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55\u5185\u5bb9");
            }
            InputStreamReader reader = new InputStreamReader(entity.getContent(), ContentType.getOrDefault((HttpEntity)entity).getCharset());
            try {
                return (ResponseBean)JSONUtil.toObjecFromReader((Reader)reader, ResponseBean.class);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    };

    public HttpClient(String url) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw ServiceException.create((int)0, (String)"http\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", null);
        }
        this.url = url;
    }

    public ResponseBean request(RequestBean requestBean) throws ServiceException {
        return this.request(requestBean, null);
    }

    public ResponseBean request(RequestBean requestBean, String authorization) throws ServiceException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.url);
        try {
            if (StringUtils.isNotBlank((CharSequence)authorization)) {
                post.addHeader("Authorization", authorization);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).build();
            post.setConfig(requestConfig);
            post.setEntity((HttpEntity)new StringEntity(JSONUtil.toJSONString((Object)requestBean), ContentType.create((String)"application/json", (String)"UTF-8")));
            ResponseBean responseBean = (ResponseBean)client.execute((HttpUriRequest)post, this.handler);
            return responseBean;
        }
        catch (ClientProtocolException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e);
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e);
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)((Object)e));
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                this.logger.error("http client\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

