/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.http;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.ErrorBean;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.operator.OperatorFactory;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerImpl
extends HttpServlet {
    private static final long serialVersionUID = 5360012772865207427L;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CONTENT_TYPE = "application/json; charset=UTF-8";
    private JsonMapper jsonMapper = JsonMapper.nonEmptyMapper();

    public void init() throws ServletException {
        String jsonMapperStr = this.getServletConfig().getInitParameter("jsonMapper");
        if (StringUtils.equals((CharSequence)"NON_NULL", (CharSequence)jsonMapperStr)) {
            this.jsonMapper = JsonMapper.nonNullMapper();
        } else if (StringUtils.equals((CharSequence)"NON_DEFAULT", (CharSequence)jsonMapperStr)) {
            this.jsonMapper = JsonMapper.nonDefaultMapper();
        } else if (StringUtils.equals((CharSequence)"ALWAYS", (CharSequence)jsonMapperStr)) {
            this.jsonMapper = JsonMapper.alwaysMapper();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = null;
        String requestDataString = null;
        try {
            requestDataString = this.getRequestDataString(request);
            this.logger.debug("{}\u7684\u539f\u59cb\u8bf7\u6c42\u662f\uff1a\n{}", (Object)request.getRemoteAddr(), (Object)requestDataString);
        }
        catch (ServiceException e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u4fe1\u606f\u51fa\u9519\u3002", (Throwable)e);
            try {
                this.renderJson(request, response, this.jsonMapper.toJson((Object)ResponseBean.create(id, (ErrorBean)ErrorBean.create((ServiceException)e))));
            }
            catch (ServiceException e1) {
                this.logger.error("\u5411\u8bf7\u6c42\u5ba2\u6237\u7aef\u53d1\u9001\u9519\u8bef\u4fe1\u606f\u5931\u8d25", (Throwable)e1);
            }
            catch (JSONException e2) {
                this.logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)requestDataString)) {
            try {
                RequestBean requestBean = (RequestBean)this.jsonMapper.fromJson(requestDataString, RequestBean.class);
                requestBean.setServletRequest(request);
                id = requestBean.getId();
                String result = this.jsonMapper.toJson((Object)OperatorFactory.getOperator((RequestBean)requestBean).operate(requestBean));
                this.logger.debug("\u7cfb\u7edf\u7ed9{}\u7684\u54cd\u5e94\uff1a\n{}", (Object)request.getRemoteAddr(), (Object)result);
                this.renderJson(request, response, result);
            }
            catch (ServiceException e) {
                this.logger.error("\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25\u3002", (Throwable)e);
                try {
                    this.renderJson(request, response, this.jsonMapper.toJson((Object)ResponseBean.create((String)id, (ErrorBean)ErrorBean.create((ServiceException)e))));
                }
                catch (ServiceException e1) {
                    this.logger.error("\u5411\u8bf7\u6c42\u5ba2\u6237\u7aef\u53d1\u9001\u9519\u8bef\u4fe1\u606f\u5931\u8d25", (Throwable)e1);
                }
                catch (JSONException e2) {
                    this.logger.error(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (JSONException e) {
                this.logger.error("\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25\u3002", (Throwable)e);
                try {
                    this.renderJson(request, response, this.jsonMapper.toJson((Object)ResponseBean.create((String)id, (ErrorBean)ErrorBean.create((ServiceException)ServiceException.create((int)-32700, (String)"\u670d\u52a1\u5668\u6536\u5230\u4e0d\u5408\u6cd5\u7684JSON\u683c\u5f0f.", (Exception)((Object)e))))));
                }
                catch (ServiceException e1) {
                    this.logger.error("\u5411\u8bf7\u6c42\u5ba2\u6237\u7aef\u53d1\u9001\u9519\u8bef\u4fe1\u606f\u5931\u8d25", (Throwable)e1);
                }
                catch (JSONException e2) {
                    this.logger.error(e2.getMessage(), (Throwable)e2);
                }
            }
        } else {
            this.renderJson(request, response, "\u5ba2\u6237\u7aef\u53d1\u9001\u7684\u8bf7\u6c42\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private String getRequestDataString(HttpServletRequest request) throws ServiceException {
        byte[] requestDataBytes = null;
        if (request.getContentLength() > 0) {
            try {
                requestDataBytes = new byte[request.getContentLength()];
            }
            catch (Throwable t) {
                this.logger.error("\u83b7\u53d6\u539f\u59cb\u8bf7\u6c42\u51fa\u9519\u3002", t);
                throw ServiceException.create((int)0, (String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\u3002", null);
            }
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
                int off = 0;
                int lastReadSum = 1;
                do {
                    lastReadSum = is.read(requestDataBytes, off, 2048);
                    off += lastReadSum;
                } while (lastReadSum >= 0);
            }
            catch (IOException e) {
                this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u539f\u59cb\u6570\u636e\u51fa\u9519\u3002", (Throwable)e);
                throw ServiceException.create((int)0, (String)"\u83b7\u53d6\u8bf7\u6c42\u539f\u59cb\u6570\u636e\u51fa\u9519\u3002", null);
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5173\u95ed\u4ecerequest\u4e2d\u83b7\u53d6\u5230\u7684\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ServletInputStream is = null;
        try {
            int c;
            is = request.getInputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            requestDataBytes = os.toByteArray();
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u539f\u59cb\u6570\u636e\u51fa\u9519\u3002", (Throwable)e);
            throw ServiceException.create((int)0, (String)"\u83b7\u53d6\u8bf7\u6c42\u539f\u59cb\u6570\u636e\u51fa\u9519\u3002", null);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error("\u5173\u95ed\u4ecerequest\u4e2d\u83b7\u53d6\u5230\u7684\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return this.getRequestString(request, requestDataBytes);
    }

    private String getRequestString(HttpServletRequest request, byte[] requestDataBytes) throws ServiceException {
        String result = null;
        try {
            result = new String(requestDataBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u8bf7\u6c42\u7f16\u7801\u4e0d\u662fUTF-8\u3002", (Throwable)e);
            throw ServiceException.create((int)0, (String)"\u8bf7\u6c42\u7f16\u7801\u4e0d\u662fUTF-8\u3002", null);
        }
        return result;
    }

    private void renderJson(HttpServletRequest request, HttpServletResponse response, String text) {
        this.render(request, response, CONTENT_TYPE, text);
    }

    private void render(HttpServletRequest request, HttpServletResponse response, String contentType, String responseStr) {
        response.setContentType(contentType);
        response.setContentLength(responseStr.getBytes(Charset.forName("UTF-8")).length);
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write(responseStr);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            this.logger.error("\u5199\u5165response\u5931\u8d25\uff0c\u4e0d\u518d\u5199\u5165\u4efb\u4f55\u5b57\u7b26\u4e32\u3002", (Throwable)e);
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

