package com.xdja.platform.mongodb;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.xdja.platform.mongodb.config.DBInfo;
import com.xdja.platform.mongodb.exception.MongodbException;

/**
 * 
 * @ProjectName：platform-mongodb
 * @ClassName：MongodbClient
 * @Description：mongodb nosql数据库客户端封装类
 * @author: renruixiu
 * @date: 2014年3月22日 上午11:26:45
 *
 */
public final class MongodbClient {

	private MongoClient client;
	
	private ServerAddress serverAddress = null;
	
	protected MongodbClient(String host, int port) throws UnknownHostException {
		serverAddress = new ServerAddress(host, port);
	}
	
	/**
	 * 
	 * @Description：初始化客户端
	 * @author: renruixiu
	 * @date: 2014年3月22日
	 * @param dbInfos
	 * @throws IllegalArgumentException
	 * @throws MongodbException 
	 */
	public void init(DBInfo ...dbInfos) throws IllegalArgumentException, MongodbException {
		if (ArrayUtils.isEmpty(dbInfos)) {
			throw new IllegalArgumentException("传入的数据库信息为空");
		}
		
		Map<String, MongoCredential> credentials = new HashMap<String, MongoCredential>();
		for (DBInfo dbInfo : dbInfos) {
			dbInfo.check();
			
			if (!credentials.containsKey(dbInfo.getDbName())) {
				credentials.put(dbInfo.getDbName(), MongoCredential.createMongoCRCredential(dbInfo.getUserName(), dbInfo.getDbName(), dbInfo.getPassword().toCharArray()));
			}
			
		}
		
		client = new MongoClient(serverAddress, new ArrayList<MongoCredential>(credentials.values()));
		
		for (String dbName : credentials.keySet()) {
			try {
				getDB(dbName).collectionExists("test");
			} catch (Throwable t) {
				throw new MongodbException("MongodbClient初始化失败", t);
			}
		}
	}
	
	/**
	 * 
	 * @Description：获取指定的数据库实例
	 * @author: renruixiu
	 * @date: 2014年3月22日
	 * @param dbName
	 * @return
	 * @throws MongodbException
	 */
	public DB getDB(String dbName) throws MongodbException {
		if (null == client) throw new MongodbException("MongodbClient未初始化，请调用init方法进行初始化");
		
		return client.getDB(dbName);
	}
}
