package com.xdja.platform.mongodb;

import java.net.UnknownHostException;
import java.util.Hashtable;

import org.apache.commons.lang3.StringUtils;

/**
 * 
 * @ProjectName：platform-mongodb
 * @ClassName：MongodbClientFactory
 * @Description：mongodb客户端工厂类
 * @author: renruixiu
 * @date: 2014年3月22日 下午2:27:09
 *
 */
public class MongodbClientFactory {

	/**
	 * 单例客户端
	 */
	private static Hashtable<String, MongodbClient> singleClients = new Hashtable<String, MongodbClient>();
	
	private static final byte[] LOCK = new byte[0];
	
	/**
	 * 
	 * @Description：以单例形式返回mongodb客户端，此处的单例是指在MongodbClientFactory范围内且相同的（host:port）
	 * @author: renruixiu
	 * @date: 2014年3月22日
	 * @param host 默认为127.0.0.1
	 * @param port 默认为27017
	 * @return
	 * @throws UnknownHostException 
	 */
	public final static MongodbClient getClient(String host, int port) throws UnknownHostException {
		if (StringUtils.isBlank(host)) host = "127.0.0.1";
		if (port <= 0) port = 27017;
		
		String tag = host + ":" + port;
		
		MongodbClient client = singleClients.get(tag);
		if (null == client) {
			synchronized (LOCK) {
				client = singleClients.get(tag);
				if (client == null) {
					client = new MongodbClient(host, port);
					
					singleClients.put(tag, client);
				}
			}
		}
		return client;
	}
}
