package com.xdja.platform.mongodb.config;

import org.apache.commons.lang3.StringUtils;

/**
 * 
 * @ProjectName：platform-mongodb
 * @ClassName：DBInfo
 * @Description：mongodb库中的数据库信息
 * @author: renruixiu
 * @date: 2014年3月22日 下午2:58:36
 * 
 */
public class DBInfo {

	/**
	 * 数据库名称
	 */
	private String dbName;
	/**
	 * 连接该数据库的用户名
	 */
	private String userName;
	/**
	 * 对应的密码
	 */
	private String password;

	public String getDbName() {
		return dbName;
	}

	public void setDbName(String dbName) {
		this.dbName = dbName;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * 
	 * @Description：检查数据库信息的完整性
	 * @author: renruixiu
	 * @date: 2014年3月22日
	 * @throws IllegalArgumentException
	 */
	public void check() throws IllegalArgumentException {
		if (StringUtils.isBlank(dbName)) throw new IllegalArgumentException("数据库名称为空");
		if (StringUtils.isBlank(userName)) throw new IllegalArgumentException("用户名为空");
		if (StringUtils.isBlank(password)) throw new IllegalArgumentException("密码为空");
	}
}
