/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.xdja.platform.mongodb.config.DBInfo;
import com.xdja.platform.mongodb.exception.MongodbException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;

public final class MongodbClient {
    private MongoClient client;
    private ServerAddress serverAddress = null;

    protected MongodbClient(String host, int port) throws UnknownHostException {
        this.serverAddress = new ServerAddress(host, port);
    }

    public void init(DBInfo ... dbInfos) throws IllegalArgumentException, MongodbException {
        if (ArrayUtils.isEmpty((Object[])dbInfos)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<String, MongoCredential> credentials = new HashMap<String, MongoCredential>();
        for (DBInfo dbInfo : dbInfos) {
            dbInfo.check();
            if (credentials.containsKey(dbInfo.getDbName())) continue;
            credentials.put(dbInfo.getDbName(), MongoCredential.createMongoCRCredential((String)dbInfo.getUserName(), (String)dbInfo.getDbName(), (char[])dbInfo.getPassword().toCharArray()));
        }
        this.client = new MongoClient(this.serverAddress, new ArrayList(credentials.values()));
        for (String dbName : credentials.keySet()) {
            try {
                this.getDB(dbName).collectionExists("test");
            }
            catch (Throwable t) {
                throw new MongodbException("MongodbClient\u521d\u59cb\u5316\u5931\u8d25", t);
            }
        }
    }

    public DB getDB(String dbName) throws MongodbException {
        if (null == this.client) {
            throw new MongodbException("MongodbClient\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u8c03\u7528init\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
        return this.client.getDB(dbName);
    }
}

