package com.xdja.platform.remoting;

import com.xdja.platform.remoting.exception.RemotingConnectException;
import com.xdja.platform.remoting.exception.RemotingSendRequestException;
import com.xdja.platform.remoting.exception.RemotingTimeoutException;
import com.xdja.platform.remoting.exception.RemotingTooMuchRequestException;
import com.xdja.platform.remoting.protocol.ProtocolData;

/**
 * 客户端接口
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public interface IClient {
	/**
	 * 同步发送请求
	 * 
	 * @param addr    要连接的服务地址
	 * @param port    要连接的服务端口
	 * @param request
	 * @param timeoutMillis
	 */
	ProtocolData sendForSync(String addr, int port, ProtocolData request, long timeoutMillis)
			throws RemotingSendRequestException, RemotingTimeoutException, RemotingConnectException,
			InterruptedException;

	/**
	 * 异步发送请求
	 * 
	 * @param addr    要连接的服务地址
	 * @param port    要连接的服务端口
	 * @param request
	 * @param timeoutMillis
	 * @param callback
	 */
	void sendForAsync(String addr, int port, ProtocolData request, long timeoutMillis, IClientCallback callback)
			throws RemotingSendRequestException, RemotingTimeoutException, RemotingConnectException,
			RemotingTooMuchRequestException, InterruptedException;

	/**
	 * 发送单程请求，不需要服务端回复
	 * 
	 * @param addr    要连接的服务端口
	 * @param port    要连接的服务端口
	 * @param request
	 * @param timeoutMillis
	 */
	void sendForOneway(String addr, int port, ProtocolData request, long timeoutMillis)
			throws RemotingSendRequestException, RemotingTimeoutException, RemotingConnectException,
			RemotingTooMuchRequestException, InterruptedException;
}
