package com.xdja.platform.remoting.serialize;

import com.xdja.platform.remoting.serialize.exception.SerializeException;

/**
 * 序列化接口
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public interface ISerialization {

	/**
	 * 
	 * 序列化
	 * @param object
	 * @return
	 * @throws SerializeException
	 */
	byte[] serialize(Object object) throws SerializeException;
	
	/**
	 * 
	 * 反序列化
	 * @param array
	 * @param clazz
	 * @return
	 * @throws SerializeException
	 */
	<T> T deserialize(byte[] array, Class<T> clazz) throws SerializeException;
}
