package com.xdja.platform.remoting.serialize;

import org.apache.commons.lang3.ClassUtils;

import com.xdja.platform.remoting.serialize.support.HessianSerialization;
import com.xdja.platform.remoting.serialize.support.JsonSerialization;

/**
 * 序列化方式枚举
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public enum Serialization {
	JSON(JsonSerialization.class.getName()),
	HESSIAN(HessianSerialization.class.getName());
	
	private ISerialization serialization;
	
	private Serialization(String className) {
		try {
			Class<?> clazz = ClassUtils.getClass(className);
			if (clazz.isInterface()) {
				throw new RuntimeException(String.format("序列化方式\"%s\"初始化失败：接口不能实例化", className));
			}
			if (ClassUtils.isAssignable(clazz, ISerialization.class)) {
				serialization = (ISerialization)clazz.newInstance();
			} else {
				throw new RuntimeException(String.format("序列化方式\"%s\"初始化失败：未实现接口%s", className, ISerialization.class));
			}
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 
	 * 获取对应的序列化方式
	 * @return
	 */
	public ISerialization getSerialization() {
		return this.serialization;
	}
	
	/**
	 * 
	 * 获取ordinal指定的序列化方式枚举
	 * @param ordinal 序列化方式枚举对应的值
	 * @return 返回值不可能为null
	 * @throws IllegalArgumentException
	 */
	public static Serialization valueOf(int ordinal) throws IllegalArgumentException {
		if (ordinal < 0 || ordinal >= Serialization.values().length) {
			throw new IllegalArgumentException(String.format("传入参数有误：ordinal的值为 0 < ordinal < %d", Serialization.values().length));
		}
		
		for (Serialization serialization : Serialization.values()) {
			if (serialization.ordinal() == ordinal) return serialization;
		}
		
		return null;
	}
}
