package com.xdja.platform.remoting.serialize;

import java.util.HashMap;
import java.util.Map;

import com.xdja.platform.remoting.serialize.exception.SerializeException;

/**
 * 提供静态序列化/反序列化操作入口
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public final class SerializationFacade {
	
	/**
	 * 存放所有的序列化方式
	 */
	private static final Map<Serialization, ISerialization> serializationMap = new HashMap<Serialization, ISerialization>(Serialization.values().length);
	
	static {
		for (Serialization serialization : Serialization.values()) {
			serializationMap.put(serialization, serialization.getSerialization());
		}
	}
	
	/**
	 * 
	 * 使用指定的序列化方式对obj进行序列化操作
	 * @param serialization 序列化方式
	 * @param obj 待序列化的内容
	 * @return
	 */
	public static final byte[] serialize(Serialization serialization, Object obj) throws SerializeException {
		return serializationMap.get(serialization).serialize(obj);
	}
	
	/**
	 * 
	 * 使用指定的序列化方式对array进行反序列化操作
	 * @param serialization 序列化方式
	 * @param array 待反序列化的内容
	 * @param clazz 反序列化后的对象类型
	 * @return
	 * @throws SerializeException
	 */
	public static final <T> T deserialize(Serialization serialization, byte[] array, Class<T> clazz) throws SerializeException {
		return serializationMap.get(serialization).deserialize(array, clazz);
	}
}
