package com.xdja.platform.remoting.serialize.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.xdja.platform.remoting.serialize.ISerialization;
import com.xdja.platform.remoting.serialize.exception.SerializeException;

/**
 * hessian序列化方式
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public class HessianSerialization implements ISerialization {

	@Override
	public byte[] serialize(Object object) throws SerializeException {
		ByteArrayOutputStream byos = new ByteArrayOutputStream();
		Hessian2Output mH2o = new Hessian2Output(byos);
		
		try {
			mH2o.writeObject(object);
			mH2o.flushBuffer();
		} catch (IOException e) {
			throw new SerializeException("使用hessian序列化失败", e);
		}
		
		return byos.toByteArray();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T deserialize(byte[] array, Class<T> clazz) throws SerializeException {
		ByteArrayInputStream byis = new ByteArrayInputStream(array);
		Hessian2Input mH2i = new Hessian2Input(byis);
		
		try {
			return (T)mH2i.readObject(clazz);
		} catch (Exception e) {
			throw new SerializeException("使用hessian反序列化失败", e);
		}
	}

}
