package com.xdja.platform.remoting.serialize.support;

import com.xdja.platform.remoting.serialize.ISerialization;
import com.xdja.platform.remoting.serialize.exception.SerializeException;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;

/**
 * json序列化方式
 * @date 2014-12-18
 * @author 任瑞修
 * 
 */
public class JsonSerialization implements ISerialization {

	@Override
	public byte[] serialize(Object object) throws SerializeException {
		try {
			return JsonMapper.alwaysMapper().toJsonBytes(object);
		} catch (JSONException e) {
			throw new SerializeException(e);
		}
	}

	@Override
	public <T> T deserialize(byte[] array, Class<T> clazz) throws SerializeException {
		try {
			return JsonMapper.alwaysMapper().fromJson(array, clazz);
		} catch (JSONException e) {
			throw new SerializeException(e);
		}
	}

}
