package com.xdja.platform.service.rmi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import com.xdja.platform.service.rmi.core.RmiServer;

/**
 * 
 * @ProjectName：platform-service
 * @ClassName：AbstractRmiServerStarter
 * @Description：rmi服务启动器基类，需要各业务系统实现
 * @author: 任瑞修
 * @date: 2013-11-5 上午9:58:54
 *
 */
public abstract class AbstractRmiServerStarter implements InitializingBean {

	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Override
	public void afterPropertiesSet() throws Exception {
		String serverIp = getServerIp();
		int serverPort = getPort();
		String serverName = getName();
		
		logger.debug("启动rmi服务：ip={},port={},name={}", serverIp, serverPort, serverName);
		
		RmiServer<RmiServerImpl> rmiServer = RmiServer.startRMIServer(serverIp, serverPort, serverName, RmiServerImpl.class);
		if(rmiServer == null) {
			throw new RuntimeException("启动rmi服务失败");
		}
	}
	
	/**
	 * 
	 * @Description：返回rmi服务的IP地址，主要用于rmi服务部署在linux环境下，解决rmi连接被重定向的问题
	 * @author: 任瑞修
	 * @date: 2013-12-5 上午10:01:47
	 * @return
	 */
	protected abstract String getServerIp();
	
	/**
	 * 
	 * @Description：返回rmi服务的端口
	 * @author: 任瑞修
	 * @date: 2013-11-5 上午9:59:18
	 * @return int rmi服务的端口
	 */
	protected abstract int getPort();
	
	/**
	 * 
	 * @Description：返回rmi服务的名称
	 * @author: 任瑞修
	 * @date: 2013-11-5 上午9:59:28
	 * @return String rmi服务的名称
	 */
	protected abstract String getName();

}
