package com.xdja.platform.service.rmi;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.client.BaseClient;
import com.xdja.platform.service.rmi.core.INormalJsonRmiInterface;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;

/**
 * 
 * @ProjectName：platform-service
 * @ClassName：RmiClient
 * @Description：调用rmi服务的客户端
 * @author: 任瑞修
 * @date: 2013-11-6 下午2:20:11
 *
 */
public class RmiClient extends BaseClient {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * rmi服务IP
	 */
	private String ip;
	/**
	 * rmi服务端口
	 */
	private int port;
	/**
	 * rmi服务名称
	 */
	private String name;
	
	/**
	 * 
	 * @Description：构造函数
	 * @param ip rmi服务IP
	 * @param port rmi服务端口
	 * @param name rmi服务名称
	 */
	public RmiClient(String ip, int port, String name) {
		this.ip = ip;
		this.port = port;
		this.name = name;
	}
	
	/**
	 * 
	 * @Description：向指定的rmi服务发起请求并得到响应
	 * @author: 任瑞修
	 * @date: 2013-11-7 上午11:43:52
	 * @param requestBean 请求
	 * @return ResponseBean
	 * @throws ServiceException 异常
	 */
	public ResponseBean request(RequestBean requestBean) throws ServiceException {
		try {
			return request(requestBean, false);
		} catch (ConnectException e) {
			try {
				return request(requestBean, true);
			} catch (ConnectException e1) {
				logger.error(e1.getMessage(), e1);
				throw ServiceException.create(0x00, e.getMessage(), e1);
			}
		}
	}
	
	/**
	 * 
	 * @Description：向指定的rmi服务发起请求并得到响应
	 * @author: 任瑞修
	 * @date: 2013-11-26 下午5:21:19
	 * @param requestBean 请求
	 * @param isUseNewClient 是否使用新rmi客户端
	 * @return
	 * @throws ServiceException
	 * @throws ConnectException
	 */
	private ResponseBean request(RequestBean requestBean, boolean isUseNewClient) throws ServiceException, ConnectException {
		try {
			com.xdja.platform.service.rmi.core.RmiClient<INormalJsonRmiInterface> client = com.xdja.platform.service.rmi.core.RmiClient
					.getRMIClient(this.ip, this.port, this.name, 
						INormalJsonRmiInterface.class, isUseNewClient);
			if(client == null) {
				throw ServiceException.create(0x00, "获取rmi客户端失败", new Exception());
			}
			
			logger.debug(JSONUtil.toJSONString(requestBean));
			
			String result = client.getRemote().excute(JSONUtil.toJSONString(requestBean));
			
			logger.debug(result);
			return JSONUtil.toObjecFromJSONString(result, ResponseBean.class);
		} catch (ConnectException e) {
			logger.error(e.getMessage(), e);
			throw e;
		} catch (ConnectIOException e) {
			logger.error(e.getMessage(), e);
			throw ServiceException.create(0x00, e.getMessage(), e);
		} catch (RemoteException e) {
			logger.error(e.getMessage(), e);
			throw ServiceException.create(0x00, e.getMessage(), e);
		} catch (JSONException e) {
			logger.error(e.getMessage(), e);
			throw ServiceException.create(0x00, e.getMessage(), e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw ServiceException.create(0x00, e.getMessage(), e);
		}
	}
}
