package com.xdja.platform.service.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.ErrorBean;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.operator.OperatorFactory;
import com.xdja.platform.service.rmi.core.INormalJsonRmiInterface;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;

/**
 * 
 * @ProjectName：platform-service
 * @ClassName：RmiServerImpl
 * @Description：RMI服务实现
 * @author: 任瑞修
 * @date: 2013-11-4 下午3:37:24
 *
 */
public class RmiServerImpl extends UnicastRemoteObject implements INormalJsonRmiInterface {

	private static final long serialVersionUID = 94609151808171833L;
	
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * @Description：构造函数
	 * @throws RemoteException 异常
	 */
	public RmiServerImpl() throws RemoteException {
		super();
	}

	private static final String clazz = INormalJsonRmiInterface.class.toString();
	
	@Override
	public String getParentInterfaceClazz() throws RemoteException {
		return clazz;
	}

	@Override
	public String excute(String jsonString) throws RemoteException {
		ResponseBean response = null;
		String id = null;
		try {
			RequestBean requestBean = JSONUtil.toObjecFromJSONString(jsonString, RequestBean.class);
			id = requestBean.getId();
			
			response = OperatorFactory.getOperator(requestBean).operate(requestBean);
		} catch (ServiceException e) {
			logger.error("业务操作失败。", e);
			response = ResponseBean.create(id, ErrorBean.create(e));
		} catch (JSONException e) {
			logger.error("业务操作失败。", e);
			response = ResponseBean.create(id, ErrorBean.create(ServiceException.create(JSONException.PARSE_ERROR, "服务器收到不合法的JSON格式.", e)));
		}
		
		try {
			return JSONUtil.toJSONString(response);
		} catch (JSONException e) {
			logger.error(e.getMessage(), e);
			throw new RemoteException(e.getMessage(), e);
		}
	}
}
