/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.rmi;

import com.xdja.platform.service.rmi.RmiServerImpl;
import com.xdja.platform.service.rmi.core.RmiServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRmiServerStarter
implements InitializingBean {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public void afterPropertiesSet() throws Exception {
        String serverIp = this.getServerIp();
        int serverPort = this.getPort();
        String serverName = this.getName();
        this.logger.debug("\u542f\u52a8rmi\u670d\u52a1\uff1aip={},port={},name={}", new Object[]{serverIp, serverPort, serverName});
        RmiServer rmiServer = RmiServer.startRMIServer(serverIp, serverPort, serverName, RmiServerImpl.class);
        if (rmiServer == null) {
            throw new RuntimeException("\u542f\u52a8rmi\u670d\u52a1\u5931\u8d25");
        }
    }

    protected abstract String getServerIp();

    protected abstract int getPort();

    protected abstract String getName();
}

