/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.rmi;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.client.BaseClient;
import com.xdja.platform.service.rmi.core.INormalJsonRmiInterface;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiClient
extends BaseClient {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String ip;
    private int port;
    private String name;

    public RmiClient(String ip, int port, String name) {
        this.ip = ip;
        this.port = port;
        this.name = name;
    }

    public ResponseBean request(RequestBean requestBean) throws ServiceException {
        try {
            return this.request(requestBean, false);
        }
        catch (ConnectException e) {
            try {
                return this.request(requestBean, true);
            }
            catch (ConnectException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
                throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e1);
            }
        }
    }

    private ResponseBean request(RequestBean requestBean, boolean isUseNewClient) throws ServiceException, ConnectException {
        try {
            com.xdja.platform.service.rmi.core.RmiClient<INormalJsonRmiInterface> client = com.xdja.platform.service.rmi.core.RmiClient.getRMIClient(this.ip, this.port, this.name, INormalJsonRmiInterface.class, isUseNewClient);
            if (client == null) {
                throw ServiceException.create((int)0, (String)"\u83b7\u53d6rmi\u5ba2\u6237\u7aef\u5931\u8d25", (Exception)new Exception());
            }
            this.logger.debug(JSONUtil.toJSONString((Object)requestBean));
            String result = client.getRemote().excute(JSONUtil.toJSONString((Object)requestBean));
            this.logger.debug(result);
            return (ResponseBean)JSONUtil.toObjecFromJSONString((String)result, ResponseBean.class);
        }
        catch (ConnectException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ConnectIOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e);
        }
        catch (RemoteException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e);
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw ServiceException.create((int)0, (String)e.getMessage(), (Exception)e);
        }
    }
}

