/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.rmi;

import com.xdja.platform.core.ServiceException;
import com.xdja.platform.service.bean.ErrorBean;
import com.xdja.platform.service.bean.RequestBean;
import com.xdja.platform.service.bean.ResponseBean;
import com.xdja.platform.service.operator.OperatorFactory;
import com.xdja.platform.service.rmi.core.INormalJsonRmiInterface;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiServerImpl
extends UnicastRemoteObject
implements INormalJsonRmiInterface {
    private static final long serialVersionUID = 94609151808171833L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String clazz = INormalJsonRmiInterface.class.toString();

    @Override
    public String getParentInterfaceClazz() throws RemoteException {
        return clazz;
    }

    @Override
    public String excute(String jsonString) throws RemoteException {
        ResponseBean response = null;
        String id = null;
        try {
            RequestBean requestBean = (RequestBean)JSONUtil.toObjecFromJSONString((String)jsonString, RequestBean.class);
            id = requestBean.getId();
            response = OperatorFactory.getOperator((RequestBean)requestBean).operate(requestBean);
        }
        catch (ServiceException e) {
            this.logger.error("\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25\u3002", (Throwable)e);
            response = ResponseBean.create((String)id, (ErrorBean)ErrorBean.create((ServiceException)e));
        }
        catch (JSONException e) {
            this.logger.error("\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25\u3002", (Throwable)e);
            response = ResponseBean.create((String)id, (ErrorBean)ErrorBean.create((ServiceException)ServiceException.create((int)-32700, (String)"\u670d\u52a1\u5668\u6536\u5230\u4e0d\u5408\u6cd5\u7684JSON\u683c\u5f0f.", (Exception)((Object)e))));
        }
        try {
            return JSONUtil.toJSONString((Object)response);
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }
}

