/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.rmi.core;

import com.xdja.platform.service.rmi.core.IRmiCommonRemote;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;

public class RmiClient<RMIInterface extends IRmiCommonRemote> {
    private static HashMap<String, RmiClient> RMI_CLIENT = new HashMap();
    private final String ip;
    private final int port;
    private final String name;
    private final RMIInterface remote;
    private final String remoteClazz;

    private RmiClient(String ip, int port, String name, RMIInterface remote, String remoteClazz) {
        this.ip = ip;
        this.port = port;
        this.name = name;
        this.remote = remote;
        this.remoteClazz = remoteClazz;
    }

    public static <RMIInterface extends IRmiCommonRemote> RmiClient<RMIInterface> getRMIClient(String ip, int port, String name, Class<RMIInterface> clazz, boolean isUseNewClient) {
        String rmiClientKey = ip + port + name;
        RmiClient<IRmiCommonRemote> rmiClient = RMI_CLIENT.get(rmiClientKey);
        if (rmiClient == null || isUseNewClient) {
            IRmiCommonRemote remote = null;
            try {
                Registry registry = null;
                registry = ip == null ? LocateRegistry.getRegistry(port) : LocateRegistry.getRegistry(ip, port);
                remote = (IRmiCommonRemote)registry.lookup(name);
                if (remote.getParentInterfaceClazz().indexOf(clazz.getName()) < 0) {
                    return null;
                }
            }
            catch (RemoteException e) {
                return null;
            }
            catch (NotBoundException e) {
                return null;
            }
            catch (ClassCastException e) {
                return null;
            }
            rmiClient = new RmiClient<IRmiCommonRemote>(ip, port, name, remote, clazz.getName());
            RMI_CLIENT.put(rmiClientKey, rmiClient);
        } else if (!rmiClient.getRemoteClazz().equals(clazz.getName())) {
            return null;
        }
        return rmiClient;
    }

    public RMIInterface getRemote() {
        return this.remote;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getRemoteClazz() {
        return this.remoteClazz;
    }
}

