/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.service.rmi.core;

import com.xdja.platform.service.rmi.core.IRmiCommonRemote;
import java.rmi.AccessException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiServer<RMIInterface extends IRmiCommonRemote> {
    private static final Logger logger = LoggerFactory.getLogger(RmiServer.class);
    private static HashMap<String, RmiServer> RMI_SERVERS = new HashMap();
    private final String serverIp;
    private final int port;
    private final String name;
    private final Remote remote;

    private RmiServer(String serverIp, int port, String name, Remote remote) {
        this.serverIp = serverIp;
        this.port = port;
        this.name = name;
        this.remote = remote;
    }

    public static <RMIInterface extends IRmiCommonRemote, RMIImpl extends RMIInterface> RmiServer<RMIInterface> startRMIServer(String serverIp, int port, String name, Class<RMIImpl> clazz) throws AccessException, RemoteException {
        IRmiCommonRemote remote = null;
        String rmiServerKey = serverIp + port + name;
        RmiServer<RMIInterface> rmiServer = RMI_SERVERS.get(rmiServerKey);
        if (rmiServer == null) {
            try {
                remote = (IRmiCommonRemote)clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("\u6784\u9020RMIImpl\u5931\u8d25", (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                logger.error("\u6784\u9020RMIImpl\u5931\u8d25", (Throwable)e);
                return null;
            }
            rmiServer = new RmiServer<RMIInterface>(serverIp, port, name, remote);
            RmiServer.getRegistry(serverIp, port).rebind(name, remote);
            RMI_SERVERS.put(rmiServerKey, rmiServer);
        }
        return rmiServer;
    }

    private static Registry getRegistry(String serverIp, int port) throws RemoteException {
        Registry registry = null;
        try {
            registry = serverIp == null ? LocateRegistry.getRegistry(port) : LocateRegistry.getRegistry(serverIp, port);
            registry.list();
        }
        catch (RemoteException e) {
            if (serverIp == null) {
                registry = LocateRegistry.createRegistry(port);
            }
            registry = LocateRegistry.createRegistry(port);
            registry = LocateRegistry.getRegistry(serverIp, port);
            registry.list();
        }
        return registry;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public String getServerIp() {
        return this.serverIp;
    }
}

