package com.xdja.platform.rpc.consumer;

import com.xdja.platform.remoting.IClient;
import com.xdja.platform.remoting.exception.RemotingConnectException;
import com.xdja.platform.remoting.exception.RemotingSendRequestException;
import com.xdja.platform.remoting.exception.RemotingTimeoutException;
import com.xdja.platform.remoting.netty.NettyClient;
import com.xdja.platform.remoting.netty.NettyClientConfig;
import com.xdja.platform.remoting.protocol.ProtocolData;
import com.xdja.platform.remoting.serialize.Serialization;
import com.xdja.platform.remoting.serialize.exception.SerializeException;
import com.xdja.platform.rpc.RpcInvocation;
import com.xdja.platform.rpc.exception.ServiceNotResponseException;

/**
 * 服务信息
 * @date 2015-1-5
 * @author rrx
 * 
 */
public class Service {
	
	private IClient client = null;
	
	/**
	 * 服务地址，多为ip地址
	 */
	private String addr = "127.0.0.1";
	/**
	 * 服务端口
	 */
	private int port = 8081;
	/**
	 * 超时时间（毫秒），默认为5000毫秒
	 */
	private long timeoutMillis = 5000;
	/**
	 * 序列化方式，默认为HESSIAN
	 */
	private Serialization serialization = Serialization.HESSIAN;
	
	public Service() {
		client = new NettyClient(new NettyClientConfig());
	}
	
	/**
	 * @return 返回{@linkplain #addr}
	 */
	public String getAddr() {
		return addr;
	}
	/**
	 * @param addr 要设置的 addr
	 */
	public void setAddr(String addr) {
		this.addr = addr;
	}
	/**
	 * @return 返回{@linkplain #port}
	 */
	public int getPort() {
		return port;
	}
	/**
	 * @param port 要设置的 port
	 */
	public void setPort(int port) {
		this.port = port;
	}
	
	/**
	 * @return 返回{@linkplain #timeoutMillis}
	 */
	public long getTimeoutMillis() {
		return timeoutMillis;
	}

	/**
	 * @param timeoutMillis 要设置的 timeoutMillis
	 */
	public void setTimeoutMillis(long timeoutMillis) {
		this.timeoutMillis = timeoutMillis;
	}

	/**
	 * @return 返回{@linkplain #serialization}
	 */
	public Serialization getSerialization() {
		return serialization;
	}

	/**
	 * @param serialization 要设置的 serialization
	 */
	public void setSerialization(Serialization serialization) {
		this.serialization = serialization;
	}

	/**
	 * 
	 * 向service对应的服务发起请求并同步等待响应
	 * @param rpcInvocation
	 * @return 不会返回null
	 * @throws RemotingSendRequestException
	 * @throws RemotingTimeoutException
	 * @throws RemotingConnectException
	 * @throws InterruptedException
	 * @throws ServiceNotResponseException
	 * @throws SerializeException 
	 */
	public ProtocolData request(RpcInvocation rpcInvocation) throws RemotingSendRequestException, RemotingTimeoutException,
			RemotingConnectException, InterruptedException, ServiceNotResponseException, SerializeException {
		
		ProtocolData request = ProtocolData.createRequest(serialization, rpcInvocation);
		
		ProtocolData response = client.sendForSync(addr, port, request, timeoutMillis);
		if (null != response) {
			return response;
		}
		
		throw new ServiceNotResponseException(String.format("服务%s:%d无响应", addr, port));
	}
}
