package com.xdja.platform.rpc.consumer;

import java.util.HashMap;
import java.util.Map;

import com.xdja.platform.rpc.exception.ServiceNotFoundException;

/**
 * 服务信息池
 * @date 2015-1-5
 * @author rrx
 * 
 */
public class ServicePool {
	
	private final static Map<String /**serviceCode*/, Service> serviceMap = new HashMap<String, Service>();
	
	private static Service defaultService = null;
	
	/**
	 * 
	 * 设置默认服务
	 * @param defaultService
	 */
	public static void setDefaultService(Service defaultService) {
		ServicePool.defaultService = defaultService;
	}
	
	/**
	 * 
	 * 添加服务
	 * @param serviceCode
	 * @param service
	 */
	public static void addService(String serviceCode, Service service) {
		serviceMap.put(serviceCode, service);
	}
	
	/**
	 * 
	 * 批量添加服务
	 * @param serviceMap
	 */
	public static void addService(Map<String, Service> serviceMap) {
		ServicePool.serviceMap.putAll(serviceMap);
	}
	
	/**
	 * 
	 * 获取指定的服务信息
	 * @param serviceCode
	 * @return 如果serviceCode对应的服务不存在则使用默认服务，否则抛出异常
	 * @throws ServiceNotFoundException
	 */
	public static Service get(String serviceCode) throws ServiceNotFoundException {
		if (serviceMap.containsKey(serviceCode)) {
			return serviceMap.get(serviceCode);
		}
		
		if (null != defaultService) {
			return defaultService;
		}
		
		throw new ServiceNotFoundException(String.format("%s对应的服务未找到，且未设置默认服务", serviceCode));
	}
	
	/**
	 * 
	 * 获取默认服务
	 * @return
	 * @throws ServiceNotFoundException
	 */
	public static Service get() throws ServiceNotFoundException {
		if (null != defaultService) {
			return defaultService;
		}
		
		throw new ServiceNotFoundException("默认服务未找到");
	}
}
