package com.xdja.platform.rpc.consumer.core;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteAccessor;

import com.xdja.platform.rpc.RpcInvocation;
import com.xdja.platform.rpc.consumer.core.invocation.DefaultRpcInvocationFactory;
import com.xdja.platform.rpc.consumer.core.invocation.RpcInvocationFactory;

/**
 * 基于RpcInvocation的基础accessor，提供RpcInvocation的生成机制
 * 
 * @date 2015-1-4
 * @author rrx
 * 
 */
public abstract class RpcInvocationBasedAccessor extends RemoteAccessor implements InitializingBean,
		RpcInvocationFactory {

	private RpcInvocationFactory defaultRpcInvocationFactory = new DefaultRpcInvocationFactory();

	public void setRpcInvocationFactory(RpcInvocationFactory rpcInvocationFactory) {
		if (null != rpcInvocationFactory) {
			this.defaultRpcInvocationFactory = rpcInvocationFactory;
		}
	}

	public RpcInvocationFactory getRpcInvocationFactory() {
		return this.defaultRpcInvocationFactory;
	}

	@Override
	public RpcInvocation createRpcInvocation(MethodInvocation methodInvocation) {
		return getRpcInvocationFactory().createRpcInvocation(methodInvocation);
	}
}
