package com.xdja.platform.rpc.consumer.core;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.support.RemoteInvocationResult;

import com.xdja.platform.rpc.RemoteService;
import com.xdja.platform.rpc.RpcInvocation;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.exception.ServiceNotResponseException;

/**
 * 服务客户端interceptor，负责使用interfaceClass初始化serviceProxy，并承担调用远程服务的职责

 * @date 2015-1-4
 * @author rrx
 * 
 */
public class ServiceClientInterceptor extends RpcInvocationBasedAccessor implements MethodInterceptor {

	private Object serviceProxy;
	
	@Override
	public void afterPropertiesSet() throws Exception {
		if (getServiceInterface() == null) {
			throw new IllegalArgumentException("Property 'serviceInterface' is required");
		}
		this.serviceProxy = new ProxyFactory(getServiceInterface(), this).getProxy(getBeanClassLoader());
	}

	public Object getServiceProxy() {
		return this.serviceProxy;
	}

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		RpcInvocation ri = createRpcInvocation(invocation);
		ri.setInterfaceName(getServiceInterface().getName());
		
		Service service = null;
		RemoteService rs = getServiceInterface().getAnnotation(RemoteService.class);
		if (null == rs || StringUtils.isBlank(rs.serviceCode())) {
			service = ServicePool.get();
		} else {
			service = ServicePool.get(rs.serviceCode());
		}
		RemoteInvocationResult rir = service.request(ri).getBody(RemoteInvocationResult.class);

		if (null == rir) {
			throw new ServiceNotResponseException(String.format("服务%s无响应", getServiceInterface().getName()));
		}
		
		if (null != rir.getException()) {
			if (null != rir.getException().getCause()) {
				throw rir.getException().getCause();
			}
			throw rir.getException();
		}
		
		return rir.getValue();
	}

}
