package com.xdja.platform.rpc.consumer.refer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.xdja.platform.rpc.consumer.core.ServiceClientInterceptor;
import com.xdja.platform.rpc.exception.ServiceInitializationException;

/**
 * 默认服务发现器
 * @date 2015-1-4
 * @author rrx
 * 
 */
public class DefaultServiceRefer extends ServiceClientInterceptor {

	private static final byte[] LOCK = new byte[0];
	
	private static Map<String, DefaultServiceRefer> serviceReferMap = new ConcurrentHashMap<String, DefaultServiceRefer>();
	
	@SuppressWarnings("unchecked")
	public static <T> T getServiceRefer(Class<T> interfaceClass) {
		DefaultServiceRefer dsr = serviceReferMap.get(interfaceClass.getName());
		if (null == dsr) {
			synchronized (LOCK) {
				dsr = new DefaultServiceRefer();
				dsr.setServiceInterface(interfaceClass);
				try {
					dsr.afterPropertiesSet();
				} catch(Exception e) {
					throw new ServiceInitializationException(String.format("服务%s初始化失败", interfaceClass.getName()), e);
				}
				
				serviceReferMap.put(interfaceClass.getName(), dsr);
			}
		}
		
		return (T)dsr.getServiceProxy();
	}
}
