/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.rpc.consumer;

import com.xdja.platform.remoting.IClient;
import com.xdja.platform.remoting.exception.RemotingConnectException;
import com.xdja.platform.remoting.exception.RemotingSendRequestException;
import com.xdja.platform.remoting.exception.RemotingTimeoutException;
import com.xdja.platform.remoting.netty.NettyClient;
import com.xdja.platform.remoting.netty.NettyClientConfig;
import com.xdja.platform.remoting.protocol.ProtocolData;
import com.xdja.platform.remoting.serialize.Serialization;
import com.xdja.platform.remoting.serialize.exception.SerializeException;
import com.xdja.platform.rpc.RpcInvocation;
import com.xdja.platform.rpc.exception.ServiceNotResponseException;

public class Service {
    private IClient client = null;
    private String addr = "127.0.0.1";
    private int port = 8081;
    private long timeoutMillis = 5000L;
    private Serialization serialization = Serialization.HESSIAN;

    public Service() {
        this.client = new NettyClient(new NettyClientConfig());
    }

    public String getAddr() {
        return this.addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public Serialization getSerialization() {
        return this.serialization;
    }

    public void setSerialization(Serialization serialization) {
        this.serialization = serialization;
    }

    public ProtocolData request(RpcInvocation rpcInvocation) throws RemotingSendRequestException, RemotingTimeoutException, RemotingConnectException, InterruptedException, ServiceNotResponseException, SerializeException {
        ProtocolData request = ProtocolData.createRequest((Serialization)this.serialization, (Object)rpcInvocation);
        ProtocolData response = this.client.sendForSync(this.addr, this.port, request, this.timeoutMillis);
        if (null != response) {
            return response;
        }
        throw new ServiceNotResponseException(String.format("\u670d\u52a1%s:%d\u65e0\u54cd\u5e94", this.addr, this.port));
    }
}

