/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.rpc.consumer;

import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.exception.ServiceNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ServicePool {
    private static final Map<String, Service> serviceMap = new HashMap<String, Service>();
    private static Service defaultService = null;

    public static void setDefaultService(Service defaultService) {
        ServicePool.defaultService = defaultService;
    }

    public static void addService(String serviceCode, Service service) {
        serviceMap.put(serviceCode, service);
    }

    public static void addService(Map<String, Service> serviceMap) {
        ServicePool.serviceMap.putAll(serviceMap);
    }

    public static Service get(String serviceCode) throws ServiceNotFoundException {
        if (serviceMap.containsKey(serviceCode)) {
            return serviceMap.get(serviceCode);
        }
        if (null != defaultService) {
            return defaultService;
        }
        throw new ServiceNotFoundException(String.format("%s\u5bf9\u5e94\u7684\u670d\u52a1\u672a\u627e\u5230\uff0c\u4e14\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u670d\u52a1", serviceCode));
    }

    public static Service get() throws ServiceNotFoundException {
        if (null != defaultService) {
            return defaultService;
        }
        throw new ServiceNotFoundException("\u9ed8\u8ba4\u670d\u52a1\u672a\u627e\u5230");
    }
}

