/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.rpc.consumer.core;

import com.xdja.platform.rpc.RemoteService;
import com.xdja.platform.rpc.RpcInvocation;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.consumer.core.RpcInvocationBasedAccessor;
import com.xdja.platform.rpc.exception.ServiceNotResponseException;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.support.RemoteInvocationResult;

public class ServiceClientInterceptor
extends RpcInvocationBasedAccessor
implements MethodInterceptor {
    private Object serviceProxy;

    public void afterPropertiesSet() throws Exception {
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        this.serviceProxy = new ProxyFactory(this.getServiceInterface(), (Interceptor)this).getProxy(this.getBeanClassLoader());
    }

    public Object getServiceProxy() {
        return this.serviceProxy;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        RpcInvocation ri = this.createRpcInvocation(invocation);
        ri.setInterfaceName(this.getServiceInterface().getName());
        Service service = null;
        RemoteService rs = this.getServiceInterface().getAnnotation(RemoteService.class);
        service = null == rs || StringUtils.isBlank((CharSequence)rs.serviceCode()) ? ServicePool.get() : ServicePool.get(rs.serviceCode());
        RemoteInvocationResult rir = (RemoteInvocationResult)service.request(ri).getBody(RemoteInvocationResult.class);
        if (null == rir) {
            throw new ServiceNotResponseException(String.format("\u670d\u52a1%s\u65e0\u54cd\u5e94", this.getServiceInterface().getName()));
        }
        if (null != rir.getException()) {
            if (null != rir.getException().getCause()) {
                throw rir.getException().getCause();
            }
            throw rir.getException();
        }
        return rir.getValue();
    }
}

