package com.xdja.platform.security.utils;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

import com.xdja.platform.security.bean.Operator;

/**
 * 
 * @Package com.xdja.platform.security.operator
 * @ClassName: OperatorUtil
 * @Description: 登录系统的操作员工具类
 * @author 任瑞修
 * @date 2013-10-22 下午4:18:50
 */
public class OperatorUtil {
	
	/**
	 * 
	 * @Description：从session中获取当前操作员
	 * @author: 任瑞修
	 * @date: 2013-11-12 上午10:13:39
	 * @return 当前操作员
	 */
	public static final Operator getOperator() {
		return (Operator) SecurityUtils.getSubject().getSession().getAttribute(Operator.OPERATOR);
	}
	
	/**
	 * 
	 * @Description：把当前操作员放入session
	 * @author: 任瑞修
	 * @date: 2013-11-12 上午10:13:17
	 * @param operator 当前操作员
	 */
	public static final void setOperator(Operator operator) {
		SecurityUtils.getSubject().getSession().setAttribute(Operator.OPERATOR, operator);
	}
	
	/**
	 * 
	 * 把指定的操作员踢下线
	 * @param subject 操作员对应的会话
	 */
	public static final void kickout(Subject subject) {
		try {
			if (null != subject) {
				Session kickoutSession = subject.getSession();
				
				if(kickoutSession != null) {
		            //设置会话的kickout属性表示踢出了
		            kickoutSession.setAttribute("kickout", true);
		        }
			}
		} catch (Exception e) {//ignore exception
		}
	}
}
