package com.xdja.platform.security.utils;

import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.crypto.hash.Sha1Hash;

/**
 * 
 * @Package com.xdja.platform.security.utils
 * @ClassName: PasswordUtils
 * @Description: 密码工具类
 * @author 任瑞修
 * @date 2013-10-25 上午8:45:46
 */
public class PasswordUtils {
	
	/**
	 * 
	 * 方法描述：加密密码
	 * 
	 * @author: 任瑞修
	 * @date: 2012-6-29 下午03:16:09
	 * @param password 待加密密码
	 * @return MD5加密后的密码信息
	 */
	public static final String encodePasswordMd5(String password) {
		return new Md5Hash(password).toHex().toLowerCase();
	}
	
	/**
	 * 
	 * 方法描述：加密密码
	 * 
	 * @author: 任瑞修
	 * @date: 2012-6-29 下午03:16:09
	 * @param password 待加密密码
	 * @return SHA1加密后的密码信息
	 */
	public static final String encodePasswordSHA1(String password) {
		return new Sha1Hash(password).toHex().toLowerCase();
	}
}
