package com.xdja.platform.security.web;

import java.util.Collection;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import com.xdja.platform.security.bean.Menu;
import com.xdja.platform.security.provider.MenuProvider;

/**
 * 
 * @ProjectName：platform-security
 * @ClassName：AbstractSecurityFilterFactoryBean
 * @Description：权限过滤器工厂
 * @author: 任瑞修
 * @date: 2013-11-12 上午10:14:30
 *
 */
public abstract class AbstractSecurityFilterFactoryBean extends ShiroFilterFactoryBean implements InitializingBean {

	@Autowired
	private MenuProvider menuProvider;
	
    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, String> filterChainDefinitions = this.getFilterChainDefinitionMap();
        filterChainDefinitions.put(this.getLoginUrl(), "anon");
        
        Collection<String> anonLinks = menuProvider.provideAnonLink();
        if (CollectionUtils.isNotEmpty(anonLinks)) {
        	for (String anonLink : anonLinks) {
        		filterChainDefinitions.put(anonLink, "anon");
        	}
        }
        
        processPermission(filterChainDefinitions, menuProvider.provideAllMenus());
        
        processCustomPermission(filterChainDefinitions);
    }
    
    /**
     *
     * 向权限过滤器链中加入自定义的权限表达式，由子类实现，一定要注意顺序
     * @param filterChainDefinitions
     */
    abstract void processCustomPermission(Map<String, String> filterChainDefinitions);
    
    /**
     * 
     * @Title: processPermission
     * @Description: 把功能菜单的权限表达式加入权限过滤器链
     * @param filterChainDefinitions 过滤器链
     * @param menus 菜单  
     */
    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Menu> menus) {
    	if (menus != null && !menus.isEmpty()) {
	    	for (Menu menu : menus) {
	            if (StringUtils.isNotBlank(menu.getPermissionKey()) && StringUtils.isNotBlank(menu.getPermission())) {
	                filterChainDefinitions.put(menu.getPermissionKey(), "perms[" + menu.getPermission() + "]");
	            }
	            
	            processPermission(filterChainDefinitions, menu.getChildren());
	        }
    	}
    }
    
}
