/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.security.bean;

import com.xdja.platform.security.bean.Menu;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Operator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPERATOR = "operator";
    private String username;
    private Map<String, Menu> menus = new LinkedHashMap<String, Menu>();
    private Set<String> permissions = new HashSet<String>();
    private Object currUser;

    public Operator(String username, Map<String, Menu> menus) {
        this.username = username;
        if (menus != null && !menus.isEmpty()) {
            this.menus.putAll(menus);
            this.parserPermission(menus.values());
        }
    }

    public <T> Operator(String username, Map<String, Menu> menus, T currUser) {
        this(username, menus);
        this.setCurrUser(currUser);
    }

    private void parserPermission(Collection<Menu> menus) {
        for (Menu menu : menus) {
            if (StringUtils.isNotBlank((CharSequence)menu.getPermission())) {
                this.permissions.add(menu.getPermission());
            }
            this.parserPermission(menu.getChildren());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Collection<Menu> getTopMenus() {
        return this.menus.values();
    }

    public Menu getTopMenu(String menuId) {
        return this.menus.get(menuId);
    }

    public <T> void setCurrUser(T currUser) {
        this.currUser = currUser;
    }

    public <T> T getCurrUser() {
        return (T)this.currUser;
    }
}

