/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.security.web;

import com.xdja.platform.security.bean.Menu;
import com.xdja.platform.security.provider.MenuProvider;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSecurityFilterFactoryBean
extends ShiroFilterFactoryBean
implements InitializingBean {
    @Autowired
    private MenuProvider menuProvider;

    public void afterPropertiesSet() throws Exception {
        Map filterChainDefinitions = this.getFilterChainDefinitionMap();
        filterChainDefinitions.put(this.getLoginUrl(), "anon");
        Collection<String> anonLinks = this.menuProvider.provideAnonLink();
        if (CollectionUtils.isNotEmpty(anonLinks)) {
            for (String anonLink : anonLinks) {
                filterChainDefinitions.put(anonLink, "anon");
            }
        }
        this.processPermission(filterChainDefinitions, this.menuProvider.provideAllMenus());
        this.processCustomPermission(filterChainDefinitions);
    }

    abstract void processCustomPermission(Map<String, String> var1);

    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Menu> menus) {
        if (menus != null && !menus.isEmpty()) {
            for (Menu menu : menus) {
                if (StringUtils.isNotBlank((CharSequence)menu.getPermissionKey()) && StringUtils.isNotBlank((CharSequence)menu.getPermission())) {
                    filterChainDefinitions.put(menu.getPermissionKey(), "perms[" + menu.getPermission() + "]");
                }
                this.processPermission(filterChainDefinitions, menu.getChildren());
            }
        }
    }
}

