package com.xdja.plugin.shadow.nonedynamic;

import android.content.Context;
import android.os.Bundle;

import com.xdja.plugin.shadow.nonedynamic.bean.InstalledShadowPluginInfo;
import com.xdja.plugin.shadow.nonedynamic.jar.ErrorCode;
import com.xdja.plugin.shadow.nonedynamic.param.ParamKeywords;

import java.io.File;
import java.util.ArrayList;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/20 <br/>
 */
public class NoneDynamicBinder extends INoneDynamic.Stub {

    private static NoneDynamicBinder instance;
    private Context context;

    private NoneDynamicBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    public static NoneDynamicBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (NoneDynamicBinder.class) {
                if (instance == null) {
                    instance = new NoneDynamicBinder(context);
                }
            }
        }
        return instance;
    }

    @Override
    public Bundle call(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String method = bundle.getString(ParamKeywords.KEY_String_method);
        if (ParamKeywords.KEY_METHOD_startPluginActivity.equals(method)) {
            String partKey = bundle.getString(ParamKeywords.KEY_String_partKey);
            String activityName = bundle.getString(ParamKeywords.KEY_String_activityName);
            int ret = ShadowManager.getInstance().startPluginActivity(partKey, activityName);
            bundle.putInt(ParamKeywords.KEY_int_ret, ret);
        } else if (ParamKeywords.KEY_METHOD_getAllInstalledPlugin.equals(method)) {
            ArrayList<InstalledShadowPluginInfo> result = ShadowManager.getInstance().getAll();
            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putParcelableArrayList(ParamKeywords.KEY_ParcelableArrayList_allInstalledPlugin, result);
        } else if (ParamKeywords.KEY_METHOD_installPlugin.equals(method)) {
            String partKey = bundle.getString(ParamKeywords.KEY_String_partKey);
            String version = bundle.getString(ParamKeywords.KEY_String_version);
            String pluginFilePath = bundle.getString(ParamKeywords.KEY_String_pluginFilePath);
            int ret = ShadowManager.getInstance().install(partKey, version, new File(pluginFilePath));
            bundle.putInt(ParamKeywords.KEY_int_ret, ret);
        } else if (ParamKeywords.KEY_METHOD_uninstallPlugin.equals(method)) {
            String partKey = bundle.getString(ParamKeywords.KEY_String_partKey);
            int ret = ShadowManager.getInstance().uninstall(partKey);
            bundle.putInt(ParamKeywords.KEY_int_ret, ret);
        } else {
            bundle.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NOT_SUPPORT_METHOD);
        }
        return bundle;
    }
}
