/*
 * Tencent is pleased to support the open source community by making Tencent Shadow available.
 * Copyright (C) 2019 THL A29 Limited, a Tencent company.  All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License"); you may not use
 * this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 *     https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.xdja.plugin.shadow.nonedynamic;

import android.content.ComponentName;
import android.content.Context;

import com.tencent.shadow.core.loader.infos.ContainerProviderInfo;
import com.tencent.shadow.core.loader.managers.ComponentManager;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

public class XdjaComponentManager extends ComponentManager {
    private static ComponentName sDefaultContainer;
    private static ComponentName sSingleTaskContainer;
    public static final ArrayList<String> sActivities = new ArrayList<>();

    public XdjaComponentManager(Context context) {
        sDefaultContainer = new ComponentName(context.getPackageName(), "com.xdja.plugin.shadow.nonedynamic.DefaultContainerActivity");
        sSingleTaskContainer = new ComponentName(context.getPackageName(), "com.xdja.plugin.shadow.nonedynamic.SingleTaskContainerActivity");
    }

    @Override
    public ComponentName onBindContainerActivity(ComponentName componentName) {
        if (!sActivities.contains(componentName.getClassName())) {
            sActivities.add(componentName.getClassName());
        }
        if (componentName.getClassName().equals("com.tencent.shadow.test.plugin.general_cases.lib.usecases.activity.TestActivityOrientation")) {
            return sSingleTaskContainer;
        }
        return sDefaultContainer;
    }


    @NotNull
    @Override
    public ContainerProviderInfo onBindContainerContentProvider(@NotNull ComponentName pluginContentProvider) {
        return new ContainerProviderInfo("com.xdja.plugin.shadow.nonedynamic.XdjaPluginContainerProvider", "com.xdja.plugin.shadow.nonedynamic.provider.authority");
    }

    @Override
    public List<BroadcastInfo> getBroadcastInfoList(String partKey) {
        List<BroadcastInfo> broadcastInfos = new ArrayList<>();
//        broadcastInfos.add(new ComponentManager.BroadcastInfo("com.tencent.shadow.test.plugin.general_cases.lib.usecases.receiver.MyReceiver",
//                new String[]{"com.tencent.test.action"}));
        return broadcastInfos;
    }
}
