package com.xdja.plugin.shadow.nonedynamic;

import android.content.ContentProvider;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Process;
import android.text.TextUtils;

import com.tencent.shadow.core.runtime.container.PluginContainerContentProvider;

import java.util.HashMap;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/14 <br/>
 */
public class XdjaPluginContainerProvider extends PluginContainerContentProvider {

    private static ContentProvider contentProvider;

    @Override
    public boolean onCreate() {
        super.onCreate();
        contentProvider = this;
        ShadowManager.getInstance().init(getContext());
        getContext().startService(new Intent(getContext(), XdjaPluginService.class));
        return false;
    }

    HashMap<String, String> callingPkgMap = new HashMap<>();

    @Override
    public Bundle call(String authority, String method, String arg, Bundle extras) {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        String callingPackage = getCallingPackage();
        if (TextUtils.isEmpty(callingPackage)) {
            if (callingUid == Process.myUid()) {
                callingPackage = getContext().getPackageName();
            }
        }
        callingPkgMap.put(callingUid + "_" + callingPid, callingPackage);

        return super.call(authority, method, arg, extras);
    }

    public static ContentProvider getContentProvider() {
        return contentProvider;
    }


}
