package com.xdja.plugin.shadow.nonedynamic.storage;

import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.plugin.shadow.nonedynamic.bean.InstalledShadowPluginInfo;
import com.xdja.simplestorage.SimpleStorage;

import java.util.ArrayList;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/14 <br/>
 */
public class StorageInstalledPlugin {

    private static final String SHADOW_NONE_DYNAMIC_PLUGIN = "ShadowNoneDynamicPlugin";

    private StorageInstalledPlugin() {
    }


    /**
     * 存储
     *
     * @param partKey
     * @param info
     * @return
     */
    public static int add(Context context, String partKey, InstalledShadowPluginInfo info) {
        SimpleStorage ss = getSimpleStorage(context);
        Gson gson = new Gson();
        String value = gson.toJson(info);
        ss.putString(partKey, value);
        return 0;
    }

    /**
     * 获取。
     * 如果version为空，则会遍历所有key，然后匹配partKey开头的，找到最大安装的version
     *
     * @param context
     * @param partKey
     * @return
     */
    public static InstalledShadowPluginInfo get(Context context, String partKey) {
        SimpleStorage ss = getSimpleStorage(context);
        String value = ss.getString(partKey, "");
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        Gson gson = new Gson();
        InstalledShadowPluginInfo pluginInfo = gson.fromJson(value, InstalledShadowPluginInfo.class);
        return pluginInfo;
    }

    /**
     * 删除
     *
     * @param context
     * @param partKey
     * @return
     */
    public static int delete(Context context, String partKey) {
        getSimpleStorage(context).remove(partKey);
        return 0;
    }

    /**
     * 获取所有
     *
     * @param context
     * @return
     */
    public static ArrayList<InstalledShadowPluginInfo> getAll(Context context) {
        ArrayList<InstalledShadowPluginInfo> result = new ArrayList<>();
        SimpleStorage ss = getSimpleStorage(context);
        String[] allKey = ss.getAllKey();
        if (allKey == null) {
            return result;
        }
        Gson gson = new Gson();
        for (String key : allKey) {
            String value = ss.getString(key, "");
            if (!TextUtils.isEmpty(value)) {
                InstalledShadowPluginInfo pluginInfo = gson.fromJson(value, InstalledShadowPluginInfo.class);
                result.add(pluginInfo);
            }
        }

        return result;
    }


    static SimpleStorage ss = null;

    private static SimpleStorage getSimpleStorage(Context context) {
        if (ss != null) {
            return ss;
        }
        ss = new SimpleStorage.Builder().setName(SHADOW_NONE_DYNAMIC_PLUGIN).build(context);
        return ss;
    }
}
